<?php
// index.php
require 'components/db_connect.php';
require 'components/header.php';
require 'components/functions.php';
?>

<!-- Background wrapper -->
<div class="bg"></div>

<main class="content">
    <div class="fade-in">
        <?php include 'components/banner_slider.php'; ?>
    </div>

    <div class="fade-in">
        <?php require 'components/teledrama_list.php'; ?>
    </div>

    <div class="fade-in">
        <?php require 'components/programme_list.php'; ?>
    </div>



    <div class="fade-in">
        <?php require 'components/split_layout_second.php'; ?>
    </div>

    <div class="fade-in">
        <?php require 'components/logos.php'; ?>
    </div>
</main>



<script>
document.addEventListener("DOMContentLoaded", function() {
    const faders = document.querySelectorAll('.fade-in');

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
                observer.unobserve(entry.target); // fade-in only once
            }
        });
    }, { threshold: 0.1 });

    faders.forEach(fader => {
        observer.observe(fader);
    });
});
</script>


<?php require 'components/footer.php'; ?>
