<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-LGW6WETHKV"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-LGW6WETHKV');
</script>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Swarnawahini - Sri Lanka’s Leading TV Channel</title>
<meta name="description" content="Swarnawahini is a leading Sri Lankan TV channel offering popular teledramas such as Jahuta, Pirimi Lamayi, Maa, Hiripoda Wassa, Sinto, Daskon, Rata Pawula, and Pablo. Watch live TV, programs, and news online.">
<meta name="keywords" content="Swarnawahini, Sri Lankan TV, teledramas, Jahuta, Pirimi Lamayi, Maa, Hiripoda Wassa, Sinto, Daskon, Rata Pawula, Pablo, live TV, programs, news">
<meta name="author" content="Swarnawahini">
<meta name="robots" content="index, follow">
<link rel="icon" type="image/x-icon" href="/Uploads/logo.png">

<!-- Bootstrap CSS -->
<link rel="stylesheet" href="/css/bootstrap.min.css">

<!-- Custom CSS -->
<link rel="stylesheet" href="/css/custom.css">

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">

<style>
/* Mobile Navbar */
@media (max-width: 991.98px) {
    .custom-navbar-collapse {
        position: fixed;
        top: 0;
        right: -100%;
        width: 250px;
        height: 100vh;
        z-index: 1050;
        transition: right 0.3s ease;
        display: flex;
        flex-direction: column;
        padding: 20px;

        /* Solid color */
        background: #1A237E;
        border-radius: 10px 0px 30px 0px;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
        color: #fff;
    }

    .custom-navbar-collapse.show {
        right: 0;
    }

    .custom-navbar-nav {
        flex-direction: column;
        gap: 15px;
        margin-top: 20px;
    }

    .custom-navbar-nav .nav-link {
        color: #fec009;
        transition: color 0.3s ease;
    }

    .custom-navbar-nav .nav-link:hover {
        color: #ffffff;
    }

    body.custom-nav-open {
        overflow: hidden;
    }

    /* Hamburger visible only on mobile */
    #customNavbarToggler {
        display: block;
    }
}

/* Desktop: hide hamburger */
@media (min-width: 992px) {
    #customNavbarToggler {
        display: none;
    }
}

/* Hamburger design */
#customNavbarToggler {
    border: none;
    background: none;
    position: relative;
    width: 30px;
    height: 22px;
    cursor: pointer;
    z-index: 1060;
}

#customNavbarToggler span {
    display: block;
    position: absolute;
    height: 3px;
    width: 100%;
    background: #fec009;
    border-radius: 2px;
    opacity: 1;
    left: 0;
    transition: all 0.3s ease;
}

#customNavbarToggler span:nth-child(1) { top: 0; }
#customNavbarToggler span:nth-child(2) { top: 9px; }
#customNavbarToggler span:nth-child(3) { top: 18px; }

/* Hamburger animation on active */
#customNavbarToggler.active span:nth-child(1) {
    transform: rotate(45deg);
    top: 9px;
}
#customNavbarToggler.active span:nth-child(2) {
    opacity: 0;
}
#customNavbarToggler.active span:nth-child(3) {
    transform: rotate(-45deg);
    top: 9px;
}
</style>

<!-- Add canonical tag -->
    <link rel="canonical" href="https://www.swarnavahini.lk<?php echo htmlspecialchars($_SERVER['REQUEST_URI']); ?>">
    <!-- Rest of your head content -->
</head>
<body>

<?php include 'loading_screen.php'; ?>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="/index.php">
            <img src="/Uploads/logo.png" alt="TV Channel Logo" style="height: 50px;">
        </a>

        <!-- Desktop Links (always visible on desktop) -->
        <div class="d-none d-lg-flex justify-content-end">
            <ul class="navbar-nav">
                <li class="nav-item"><a class="nav-link" href="/index.php">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="/pages/teledramas.php">Teledramas</a></li>
                <li class="nav-item"><a class="nav-link" href="/pages/programmes.php">Programmes</a></li>
                <li class="nav-item"><a class="nav-link" href="https://liveatsrilanka.lk/" target="_blank">News</a></li>
                <li class="nav-item"><a class="nav-link" href="/pages/contact_form_with_map.php">Contact</a></li>
                <li class="nav-item">
                    <a href="/pages/live.php" class="live-button">
                        <span class="live-circle"></span> LIVE
                    </a>
                </li>
            </ul>
        </div>

        <!-- Hamburger (mobile only) -->
        <button id="customNavbarToggler" class="d-lg-none" aria-label="Toggle navigation">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </div>
</nav>

<!-- Mobile Menu -->
<div class="custom-navbar-collapse d-lg-none" id="customNavbarCollapse">
    <ul class="navbar-nav custom-navbar-nav">
        <li class="nav-item"><a class="nav-link" href="/index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="/pages/teledramas.php">Teledramas</a></li>
        <li class="nav-item"><a class="nav-link" href="/pages/programmes.php">Programmes</a></li>
        <li class="nav-item"><a class="nav-link" href="https://liveatsrilanka.lk/" target="_blank">News</a></li>
        <li class="nav-item"><a class="nav-link" href="/pages/contact_form_with_map.php">Contact</a></li>
        <li class="nav-item">
            <a href="/pages/live.php" class="live-button">
                <span class="live-circle"></span> LIVE
            </a>
        </li>
    </ul>
</div>

<!-- Bootstrap JS -->
<script src="js/bootstrap.bundle.min.js"></script>

<script>
// Hamburger toggle functionality
const toggler = document.getElementById('customNavbarToggler');
const collapse = document.getElementById('customNavbarCollapse');

toggler.addEventListener('click', () => {
    collapse.classList.toggle('show');
    toggler.classList.toggle('active');
    document.body.classList.toggle('custom-nav-open');
});

// Close menu when clicking outside
document.addEventListener('click', (e) => {
    if (!collapse.contains(e.target) && !toggler.contains(e.target)) {
        collapse.classList.remove('show');
        toggler.classList.remove('active');
        document.body.classList.remove('custom-nav-open');
    }
});
</script>

</body>
</html>