<?php
// C:\xampp\htdocs\swarnawahini_web\components\programme_list.php
$api_key = 'AIzaSyBAON_ChCgF5BEXX7ijp--GImeRmAHdUBY';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$items_per_page = 6;
$offset = ($page - 1) * $items_per_page;

$total_items = 0;
$programmes = [];

// Fetch total items and programmes
try {
    $total_stmt = $conn->query("SELECT COUNT(*) FROM programmes");
    $total_items = $total_stmt->fetchColumn();

    $stmt = $conn->prepare("SELECT * FROM programmes ORDER BY sort_order ASC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $programmes = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("Database error in programme_list.php: " . $e->getMessage());
    $programmes = [];
    $total_items = 0;
}

$total_pages = ceil($total_items / $items_per_page);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Programmes | Swarnawahini</title>
    <!-- Include Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Global Reset and Base Styles */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: Poppins, sans-serif;
            background: rgb(25, 52, 134);
            margin: 0;
            padding: 90px 0 0;
            overflow-x: hidden;
        }

        /* Programme Container */
        .container.ts {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            color: white;
        }

                /* Top Right Button */
        .top-right-btn {
            position: absolute;
            top: 20px;
            right: 20px;
            background-color: #FFC107;
            color: #1A237E;
            padding: 8px 15px;
            border-radius: 15px;
            font-family: 'Poppins', sans-serif;
            font-weight: bold;
            text-decoration: none;
            transition: background-color 0.3s ease, transform 0.3s ease;
            border: none;
            cursor: pointer;
        }
        /* Page Title */
        .page-title {
            text-align: center;
            margin-bottom: 30px;
            font-size: 2rem;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            color: white;
        }

        /* Row and Grid for Controlled Horizontal Layout */
        .row {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* Enforce 3 columns */
            gap: 1.5rem; /* Match gutter-x */
            justify-content: center;
            padding: 0 0.75rem; /* Half of gutter-x for edge spacing */
        }

        .col {
            display: flex;
            justify-content: center;
        }

        /* Cards */
        .card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            width: 100%;
            max-width: 350px; /* Wider card width */
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 5px rgba(0, 0, 0, 0.2);
            background: rgba(255, 255, 255, 0.25);
        }

        .card-img-top {
            border-top-left-radius: 15px;
            border-top-right-radius: 15px;
            width: 100%;
            height: 200px;
            object-fit: cover;
        }

        .card-body {
            padding: 15px;
            color: white;
        }

        .card-text {
            font-family: 'Poppins', sans-serif;
            font-weight: 400;
            font-size: 16px;
            color: #ecf0f1;
            margin-bottom: 15px;
        }

        .btn.btn-primary {
            display: inline-flex;
            align-items: center;
            background-color: #FFC107;
            color: #1A237E;
            padding: 8px 15px;
            border-radius: 15px;
            font-family: 'Poppins', sans-serif;
            font-weight: bold;
            text-decoration: none;
            transition: background-color 0.3s ease, transform 0.3s ease;
            border: none;
        }

        .btn.btn-primary:hover {
            background-color: #ff0000;
            color: #1A237E;
            transform: scale(1.05);
            text-decoration: none;
        }

        /* Updated Pagination */
        .pagination {
            margin-top: 2rem;
            display: flex;
            justify-content: center;
            gap: 0.5rem; /* Space between items */
        }

        .pagination .page-link {
            color: #1A237E;
            background-color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0, 25, 118, 0.2);
            padding: 8px 15px;
            min-width: 40px;
            text-align: center;
            border-radius: 50px; /* Fully rounded corners */
            transition: background-color 0.3s ease, transform 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .pagination .page-item.active .page-link {
            background-color: #FFC107;
            color: #1A237E;
            border-color: #FFC107;
            transform: scale(1.1); /* Slight scale on active */
        }

        .pagination .page-item.disabled .page-link {
            background-color: rgba(255, 255, 255, 0.5);
            color: #6c757d;
            opacity: 0.7;
            cursor: not-allowed;
        }

        .pagination .page-link:hover {
            background-color: #ff0000;
            color: #ffffff;
            transform: scale(1.05); /* Slight scale on hover */
        }

        /* Responsive Adjustments */
        @media (max-width: 991px) {
            .container.ts {
                border-radius: 10px;
            }
            .page-title {
                font-size: 1.5rem;
            }
            .row {
                grid-template-columns: repeat(2, 1fr); /* Two columns on medium screens */
            }
            .card {
                border-radius: 10px;
                max-width: 350px;
            }
            .card-img-top {
                height: 150px;
            }
            .pagination .page-link {
                padding: 6px 12px;
                min-width: 35px;
            }
        }

        @media (max-width: 576px) {
            .container.ts {
                border-radius: 8px;
            }
            .page-title {
                font-size: 1.25rem;
            }
            .row {
                grid-template-columns: 1fr; /* Single column on small screens */
            }
            .card {
                border-radius: 20px;
                max-width: 100%; /* Full width on mobile */
            }
            .card-img-top {
                height: 120px;
            }
            .card-body {
                padding: 10px;
            }
            .card-text {
                font-size: 14px;
            }
            .btn.btn-primary {
                padding: 6px 12px;
                font-size: 14px;
            }
            .pagination .page-link {
                padding: 5px 10px;
                min-width: 30px;
            }
        }
    </style>
</head>
<body>
    <div class="container ts">
    <div class="teledrama-container">
        <a href="pages/programmes.php" class="top-right-btn">More</a>
        <h1 class="page-title">Programmes</h1>
        <div class="row g-4 justify-content-center">
            <?php foreach ($programmes as $row): ?>
                <?php
                    // Use the cover_image from the database
                    $thumbnail = !empty($row['cover_image'])
                        ? $row['cover_image']
                        : 'assets/images/default-placeholder.jpg'; // fallback image path
                ?>
                <div class="col">
                    <div class="card">
                        <img src="<?php echo htmlspecialchars($thumbnail); ?>"
                             class="card-img-top"
                             alt="<?php echo htmlspecialchars($row['title']); ?>"
                             style="width:100%; height:auto; object-fit:contain;">

                        <div class="card-body">
                            <p class="card-text"><?php echo htmlspecialchars($row['description']); ?></p>
                            <a href="/programme_detail.php?id=<?php echo $row['id']; ?>" class="btn btn-primary">
                                <?php echo htmlspecialchars($row['title']); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>



        </div>
    </div>

    <!-- Include Bootstrap JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>