<?php
// Start output buffering to prevent stray whitespace
ob_start();

// Suppress PHP errors from breaking XML
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

// Set XML header
header('Content-Type: application/xml; charset=UTF-8');

// Output XML declaration and urlset start
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

// Base URL of your website
$baseUrl = 'https://www.swarnavahini.lk/';

// --- Static pages ---
$pages = [
    ['url' => '', 'lastmod' => '2025-10-15', 'priority' => '1.0'],
    ['url' => 'pages/teledramas.php', 'lastmod' => '2025-10-15', 'priority' => '0.8'],
    ['url' => 'pages/programmes.php', 'lastmod' => '2025-10-15', 'priority' => '0.8'],
    ['url' => 'pages/contact_form_with_map.php', 'lastmod' => '2025-10-15', 'priority' => '0.6'],
    ['url' => 'pages/live.php', 'lastmod' => '2025-10-15', 'priority' => '0.9']
];

// --- Dynamic pages from DB ---
require_once __DIR__ . '/components/db_connect.php'; // Make sure path is correct

try {
    $stmt = $conn->query("SELECT url, last_modified FROM teledramas");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!empty($row['url'])) {
            $lastmod = !empty($row['last_modified']) && strtotime($row['last_modified']) !== false
                ? date('c', strtotime($row['last_modified']))
                : date('c'); // fallback to current date if missing
            $pages[] = [
                'url' => $row['url'],
                'lastmod' => $lastmod,
                'priority' => '0.7'
            ];
        }
    }
} catch (Exception $e) {
    // Fail silently to prevent breaking XML
}

// --- Output XML for all pages ---
foreach ($pages as $page) {
    $loc = rtrim($baseUrl, '/') . '/' . ltrim($page['url'], '/');
    echo '<url>';
    echo '<loc>' . htmlspecialchars($loc, ENT_XML1, 'UTF-8') . '</loc>';
    echo '<lastmod>' . $page['lastmod'] . '</lastmod>';
    echo '<changefreq>weekly</changefreq>';
    echo '<priority>' . htmlspecialchars($page['priority'], ENT_XML1, 'UTF-8') . '</priority>';
    echo '</url>';
}

// Close urlset
echo '</urlset>';

// Flush buffer and stop
ob_end_flush();
exit;
