<?php
require 'components/db_connect.php';

$banners = [];

try {
    if ($conn instanceof PDO) {
        $stmt = $conn->query("SELECT * FROM banners ORDER BY created_at DESC");
        $banners = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } elseif ($conn instanceof mysqli) {
        $result = $conn->query("SELECT * FROM banners ORDER BY created_at DESC");
        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $banners[] = $row;
            }
        }
    } else {
        throw new Exception("Unsupported database connection type.");
    }
} catch (Exception $e) {
    $banners = [];
}
?>

<?php if (!empty($banners)) { ?>
    <div class="banner-slider container-banner">
        <div class="banner-slides">
            <?php foreach ($banners as $index => $banner) { ?>
                <div class="banner-slide <?php echo $index === 0 ? 'active' : ''; ?>">
                    <img src="/swarnawahini_web/Uploads/banners/<?php echo htmlspecialchars($banner['image_path']); ?>" alt="Banner <?php echo $index + 1; ?>">
                </div>
            <?php } ?>
        </div>
        <button class="banner-prev">&#10094;</button>
        <button class="banner-next">&#10095;</button>
        <div class="banner-dots">
            <?php foreach ($banners as $index => $banner) { ?>
                <span class="banner-dot <?php echo $index === 0 ? 'active' : ''; ?>" data-index="<?php echo $index; ?>"></span>
            <?php } ?>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const slides = document.querySelectorAll('.banner-slide');
    const dots = document.querySelectorAll('.banner-dot');
    const prevButton = document.querySelector('.banner-prev');
    const nextButton = document.querySelector('.banner-next');
    let currentIndex = 0;

    // Swipe variables
    let touchStartX = 0;
    let touchEndX = 0;

    function updateSlider(index) {
        slides.forEach((slide, i) => {
            slide.classList.toggle('active', i === index);
        });
        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === index);
        });
        currentIndex = index;
    }

    // Dot click
    dots.forEach((dot, i) => {
        dot.addEventListener('click', () => updateSlider(i));
    });

    // Prev/Next buttons
    prevButton.addEventListener('click', () => {
        currentIndex = (currentIndex - 1 + slides.length) % slides.length;
        updateSlider(currentIndex);
    });

    nextButton.addEventListener('click', () => {
        currentIndex = (currentIndex + 1) % slides.length;
        updateSlider(currentIndex);
    });

    // Auto slide every 5 seconds
    let autoSlide = setInterval(() => {
        currentIndex = (currentIndex + 1) % slides.length;
        updateSlider(currentIndex);
    }, 5000);

    // Swipe support
    const sliderContainer = document.querySelector('.banner-slider');

    sliderContainer.addEventListener('touchstart', e => {
        touchStartX = e.changedTouches[0].screenX;
    });

    sliderContainer.addEventListener('touchend', e => {
        touchEndX = e.changedTouches[0].screenX;
        handleGesture();
    });

    function handleGesture() {
        if (touchEndX < touchStartX - 40) { // swipe left
            currentIndex = (currentIndex + 1) % slides.length;
            updateSlider(currentIndex);
            resetAutoSlide();
        }
        if (touchEndX > touchStartX + 40) { // swipe right
            currentIndex = (currentIndex - 1 + slides.length) % slides.length;
            updateSlider(currentIndex);
            resetAutoSlide();
        }
    }

    function resetAutoSlide() {
        clearInterval(autoSlide);
        autoSlide = setInterval(() => {
            currentIndex = (currentIndex + 1) % slides.length;
            updateSlider(currentIndex);
        }, 5000);
    }

    // Initialize first slide
    updateSlider(currentIndex);
});
</script>

<?php } ?>
