<?php
// Database connection
try {
    require 'db_connect.php';
    if (!$conn) throw new Exception("Database connection is null.");
} catch (Exception $e) {
    $error_message = "Failed to connect to the database: " . $e->getMessage();
    goto render_page;
}

// ✅ Now Showing logic
date_default_timezone_set("Asia/Colombo");
$currentDay = date('l');
$currentTime = date('H:i:s');

$now_stmt = $conn->prepare("
    SELECT * FROM tv_schedule 
    WHERE day = :day 
    AND time <= :time 
    ORDER BY time DESC 
    LIMIT 1
");
$now_stmt->execute([':day'=>$currentDay, ':time'=>$currentTime]);
$now_program = $now_stmt->fetch(PDO::FETCH_ASSOC);

render_page:
?>

<!-- ✅ Live TV Player with attached alert bar -->
<div class="video-player-wrapper">

    <!-- Player -->
    <div class="video-player">
        <iframe 
            src="https://iframes.5centscdn.com/videojs/hls/aHR0cHM6Ly9qazNsejh4a2x3NzktaGxzLWxpdmUuNWNlbnRzY2RuLmNvbS9saXZlLzYyMjZmN2NiZTU5ZTk5YTkwYjVjZWY2Zjk0Zjk2NmZkLnNkcC9wbGF5bGlzdC5tM3U4P21kNT1GV3NKT0RrT0JvVjkxNXpycWlYcWZ3JmV4cGlyZXM9MTc0NDI3MjAzMw=="
            frameborder="0" 
            allow="autoplay; encrypted-media" 
            allowfullscreen
            class="video-iframe"
        ></iframe>
    </div>

    <!-- Attached Now Showing bar -->
    <div class="player-alert-bar">
        <?php if (isset($error_message)): ?>
            <span class="alert-text error"><?php echo htmlspecialchars($error_message); ?></span>
        <?php elseif ($now_program): ?>
            <span class="alert-label">🔴 Live Now</span>
            <span class="alert-text">
                <?php echo htmlspecialchars($now_program['program_name']); ?> 
                (<?php echo date('h:i A', strtotime($now_program['time'])); ?>)
            </span>
        <?php else: ?>
            <span class="alert-label">📺 Live Info</span>
            <span class="alert-text">No program currently airing.</span>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Wrapper (keeps alert attached) */
    .video-player-wrapper {
        max-width: 1200px;
        margin: 20px auto;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }

    /* Player */
    .video-player {
        position: relative;
        width: 100%;
        padding-top: 56.25%; /* 16:9 */
        background: #000;
    }
    .video-iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border: none;
    }

    /* ✅ Attached alert bar */
    .player-alert-bar {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 12px 20px;
        font-size: 1rem;
        font-weight: 500;
        background: linear-gradient(90deg, #fdc206, #ff9800);
        color: #000;
    }
    .player-alert-bar .alert-label {
        font-weight: 700;
        text-transform: uppercase;
    }
    .player-alert-bar .alert-text {
        flex: 1;
    }
    .player-alert-bar .error {
        color: #fff;
        background: rgba(220, 53, 69, 0.9);
        padding: 6px 10px;
        border-radius: 6px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .player-alert-bar {
            font-size: 0.9rem;
            padding: 10px 15px;
        }
    }
    @media (max-width: 576px) {
        .player-alert-bar {
            flex-direction: column;
            align-items: flex-start;
            font-size: 0.85rem;
        }
    }
</style>
