<?php
// Database connection
try {
    require 'db_connect.php';
    if (!$conn) throw new Exception("Database connection is null.");
} catch (Exception $e) {
    $error_message = "Failed to connect to the database: " . $e->getMessage();
    $schedule = [];
    $days = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
    foreach ($days as $day) { $schedule[$day] = []; }
    goto render_page;
}

// Days list
$days = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
$schedule = [];

// Fetch schedule
foreach ($days as $day) {
    $stmt = $conn->prepare("SELECT time, program_name FROM tv_schedule WHERE day = :day ORDER BY time ASC");
    $stmt->execute([':day' => $day]);
    $schedule[$day] = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// ✅ Now Showing
date_default_timezone_set("Asia/Colombo");
$currentDay = date('l');
$currentTime = date('H:i:s');

$now_stmt = $conn->prepare("
    SELECT * FROM tv_schedule 
    WHERE day = :day 
    AND time <= :time 
    ORDER BY time DESC 
    LIMIT 1
");
$now_stmt->execute([':day'=>$currentDay, ':time'=>$currentTime]);
$now_program = $now_stmt->fetch(PDO::FETCH_ASSOC);

render_page:
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TV Schedule | Swarnawahini</title>
    <style>
        .schedule-container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
            background: transparent;
        }
        .schedule-title {
            text-align: center;
            margin-bottom: 30px;
            font-size: 2rem;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            color: white;
        }

        /* ✅ Now Showing alert styling */
        .alert { 
            padding: 15px; 
            border-radius: 10px; 
            margin-bottom: 20px; 
            text-align: center; 
            font-size: 1.1rem; 
        }
        .alert-info { 
            background: rgba(255, 255, 255, 0.2); 
            border: 3px solid #fdc206;
            color: white; 
        }
        .alert-warning { 
            background: rgba(255, 193, 7, 0.2); 
            border: 1px solid rgba(255,193,7,0.5); 
            color: white;
        }

        .day-section {
            margin-bottom: 15px;
        }
        .day-header {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            padding: 15px;
            cursor: pointer;
            transition: background 0.3s ease;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            color: white;
        }
        .day-header:hover {
            background: rgba(255, 255, 255, 0.25);
        }
        .day-header h3 {
            margin: 0;
            font-size: 1.25rem;
            color: white;
        }
        .toggle-icon {
            font-size: 1.5rem;
        }
        .day-content {
            display: none;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            padding: 20px;
            margin-top: 5px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            color: white;
        }
        .day-content.active {
            display: block;
        }
        .schedule-table {
            width: 100%;
            border-collapse: collapse;
        }
        .schedule-table th, .schedule-table td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            color: inherit;
        }
        .schedule-table th {
            background: rgba(255, 255, 255, 0.2);
        }
        .error-message {
            background: rgba(255, 0, 0, 0.2);
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            color: inherit;
        }
        .no-programs {
            text-align: center;
            font-style: italic;
            opacity: 0.7;
            color: inherit;
        }
        @media (max-width: 767px) {
            .day-header, .day-content {
                border-radius: 10px;
            }
            .schedule-title {
                font-size: 1.5rem;
            }
            .day-header h3 {
                font-size: 1rem;
            }
        }
        @media (max-width: 576px) {
            .day-header, .day-content {
                border-radius: 8px;
            }
            .schedule-title {
                font-size: 1.25rem;
            }
            .day-header h3 {
                font-size: 0.9rem;
            }
            .schedule-table th, .schedule-table td {
                font-size: 0.85rem;
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <div class="schedule-container">
        <h2 class="schedule-title">Weekly TV Schedule</h2>

        <!-- ✅ Now Showing -->
        

        <?php if (isset($error_message)): ?>
            <div class="error-message"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>

        <?php foreach ($days as $day): ?>
            <div class="day-section">
                <div class="day-header" onclick="toggleDay(this)">
                    <h3><?php echo $day; ?></h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="day-content">
                    <?php if (empty($schedule[$day])): ?>
                        <p class="no-programs">No programs scheduled for <?php echo $day; ?>.</p>
                    <?php else: ?>
                        <table class="schedule-table">
                            <thead>
                                <tr>
                                    <th>Time</th>
                                    <th>Program</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($schedule[$day] as $program): ?>
                                    <tr>
                                        <td><?php echo date('h:i A', strtotime($program['time'])); ?></td>
                                        <td><?php echo htmlspecialchars($program['program_name']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <script>
        function toggleDay(header) {
            const content = header.nextElementSibling;
            const icon = header.querySelector('.toggle-icon');
            const isActive = content.classList.contains('active');

            document.querySelectorAll('.day-content.active').forEach(item => {
                if (item !== content) {
                    item.classList.remove('active');
                    item.previousElementSibling.querySelector('.toggle-icon').textContent = '+';
                }
            });

            if (!isActive) {
                content.classList.add('active');
                icon.textContent = '−';
            } else {
                content.classList.remove('active');
                icon.textContent = '+';
            }
        }
    </script>
</body>
</html>
