<?php
$page_title = "Special Programmes | Swarnawahini"; 
require_once '../config.php';
require '../components/db_connect.php';

// -----------------------------------------
// PHP LOGIC (Data Fetching)
// -----------------------------------------

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$items_per_page = 6; 
$offset = ($page - 1) * $items_per_page;

$shows = [];
$total_pages = 1;

try {
    $count_stmt = $conn->query("SELECT COUNT(*) FROM special_embeds");
    $total_items = $count_stmt->fetchColumn();
    $total_pages = ceil($total_items / $items_per_page);

    $stmt = $conn->prepare("SELECT * FROM special_embeds ORDER BY id DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $shows = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    $shows = [];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        /* --- GLOBAL STYLES (MATCHING TELEDRAMA PAGE) --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            padding-top: 90px; /* Matched to reference */
            padding-bottom: 80px;
            overflow-x: hidden;
        }

        /* --- MAIN GLASS CONTAINER --- */
        .glass-container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.2);
            width: 95%; 
            position: relative;
            z-index: 1; 
        }

        .page-title {
            text-align: center;
            margin-bottom: 30px;
            font-size: 2rem;
            font-weight: 600;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            color: white;
        }

        /* --- VIDEO CARD STYLES (MATCHING TELEDRAMA CARD) --- */
        .video-card {
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(20px) saturate(200%);
            -webkit-backdrop-filter: blur(20px) saturate(200%);
            border-radius: 20px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.15);
            overflow: hidden;
            width: 100%;
            display: flex;
            flex-direction: column;
            background-image: linear-gradient(
                135deg, 
                rgba(255, 255, 255, 0.15) 0%, 
                rgba(255, 255, 255, 0.02) 100%
            );
            margin-bottom: 20px;
        }

        /* --- THUMBNAIL WRAPPER --- */
        .custom-thumb-wrapper {
            position: relative;
            width: 100%;
            padding-bottom: 56.25%; /* 16:9 Aspect Ratio */
            background: #000;
            cursor: pointer;
            overflow: hidden;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }

        .custom-thumb-wrapper img {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .play-overlay {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: #FFC107;
            font-size: 5rem;
            z-index: 10;
            text-shadow: 0 4px 20px rgba(0,0,0,0.8);
            pointer-events: none;
            transition: transform 0.2s ease;
        }
        
        .custom-thumb-wrapper:active .play-overlay {
            transform: translate(-50%, -50%) scale(0.9);
        }

        /* --- VIDEO WRAPPER --- */
        .generic-video-wrapper {
            position: relative;
            width: 100%;
            padding-bottom: 56.25%; 
            height: 0;
            background: #000;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }

        .generic-video-wrapper iframe,
        .generic-video-wrapper object,
        .generic-video-wrapper embed,
        .generic-video-wrapper video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100% !important;
            height: 100% !important;
            border: none;
        }

        .d-none { display: none !important; }

        /* --- CARD BODY & YELLOW TITLE BOX --- */
        .video-card-body {
            padding: 20px;
            text-align: left;
            flex-grow: 1;
            display: flex;
            align-items: center;
        }

        .program-title-box {
            background-color: #FFC107; /* Play button yellow */
            color: #1A237E; /* Deep Blue text (matches theme contrast) */
            padding: 10px 25px;
            border-radius: 30px; /* Curved box */
            font-size: 1.1rem;
            font-family: 'Poppins', sans-serif;
            font-weight: 700;
            display: inline-block;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            text-decoration: none;
            line-height: 1.4;
        }

        /* --- PAGINATION (MATCHING REFERENCE) --- */
        .pagination {
            margin-top: 2rem;
            display: flex;
            justify-content: center;
            gap: 0.5rem;
        }

        .pagination .page-link {
            color: #1A237E;
            background-color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0, 25, 118, 0.2);
            padding: 8px 15px;
            min-width: 40px;
            text-align: center;
            border-radius: 50px;
            transition: background-color 0.3s ease, transform 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .pagination .page-item.active .page-link {
            background-color: #FFC107;
            color: #1A237E;
            border-color: #FFC107;
            transform: scale(1.1);
        }

        .pagination .page-link:hover {
            background-color: #ff0000;
            color: #ffffff;
            transform: scale(1.05);
        }

        @media (max-width: 991px) {
            .glass-container { border-radius: 10px; }
            .page-title { font-size: 1.5rem; }
        }
        
        @media (max-width: 576px) {
            .video-card { max-width: 100%; }
            .play-overlay { font-size: 3rem; }
            .program-title-box { font-size: 1rem; padding: 8px 15px; }
        }
    </style>
</head>
<body>

<?php require '../components/header.php'; ?>

<div class="glass-container">
    
    <h1 class="page-title">Special Programmes</h1>
    
    <div class="row g-4 justify-content-center">
        <?php if (!empty($shows)): ?>
            <?php foreach ($shows as $row): ?>
                
                <div class="col-12 col-lg-6"> 
                    <div class="video-card">
                        
                        <?php if (!empty($row['thumbnail_url'])): ?>
                            <div class="custom-thumb-wrapper" id="thumb-<?php echo $row['id']; ?>" onclick="playEmbed(<?php echo $row['id']; ?>)">
                                <img src="/Uploads/embeds/<?php echo htmlspecialchars($row['thumbnail_url']); ?>" alt="<?php echo htmlspecialchars($row['title']); ?>">
                                <div class="play-overlay">
                                    <i class="bi bi-play-circle-fill"></i>
                                </div>
                            </div>

                            <div class="generic-video-wrapper d-none" id="embed-<?php echo $row['id']; ?>">
                                <?php echo $row['embed_code']; ?>
                            </div>

                        <?php else: ?>
                            <div class="generic-video-wrapper">
                                <?php echo $row['embed_code']; ?>
                            </div>
                        <?php endif; ?>

                        <div class="video-card-body">
                            <div class="program-title-box">
                                <?php echo htmlspecialchars($row['title']); ?>
                            </div>
                        </div>

                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12 text-center py-5">
                <i class="bi bi-collection-play" style="font-size: 4rem; color: rgba(255,255,255,0.3);"></i>
                <p class="mt-3 text-white-50">No special programmes added yet.</p>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($total_pages > 1): ?>
        <nav aria-label="Page navigation">
            <ul class="pagination">
                <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                </li>
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                <?php endfor; ?>
                <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                </li>
            </ul>
        </nav>
    <?php endif; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function playEmbed(id) {
        const thumb = document.getElementById('thumb-' + id);
        if (thumb) thumb.classList.add('d-none');

        const embedContainer = document.getElementById('embed-' + id);
        if (embedContainer) {
            embedContainer.classList.remove('d-none');

            // Force Autoplay on click
            const iframe = embedContainer.querySelector('iframe');
            if (iframe) {
                let src = iframe.getAttribute('src');
                if (src && !src.includes('autoplay=1')) {
                    const separator = src.includes('?') ? '&' : '?';
                    iframe.setAttribute('src', src + separator + "autoplay=1");
                }
            }
        }
    }
</script>

</body>
</html>

<?php require '../components/footer.php'; ?>