<?php
$page_title = "All Teledramas";
require '../components/db_connect.php';
require '../components/header.php';

// Current server time and day
date_default_timezone_set("Asia/Colombo"); // Set your timezone
$currentTime = date("H:i");
$currentDay  = date("D"); // Sat, Sun, Mon...

// Time range
$start = "19:30";
$end   = "20:30";

// Check if today is Saturday or Sunday
$isWeekend = ($currentDay == "Sat" || $currentDay == "Sun");

// Check if current time is between 19:30 and 20:30
$inTimeRange = ($currentTime >= $start && $currentTime <= $end);

// Condition to hide video
$hideVideo = ($isWeekend && $inTimeRange);
?>

<?php if (!$hideVideo): ?>
    <?php require '../components/video_player.php'; ?>
<?php endif; ?>

<?php require '../components/footer.php'; ?>
