<?php
$page_title = "Ridee Reyak | Swarnawahini"; 
require_once '../config.php';
require '../components/db_connect.php';
require '../components/header.php';

// -----------------------------------------
// PHP LOGIC STARTS HERE
// -----------------------------------------

// Pagination Logic
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$items_per_page = 6;
$offset = ($page - 1) * $items_per_page;

// Initialize variables
$tiktoks = [];
$total_pages = 1;

// Fetch Data
try {
    // Get total count
    $count_stmt = $conn->query("SELECT COUNT(*) FROM tiktok_embeds");
    $total_items = $count_stmt->fetchColumn();
    $total_pages = ceil($total_items / $items_per_page);

    // Get items - SORTED BY ID DESC (Newest Added First)
    $stmt = $conn->prepare("SELECT * FROM tiktok_embeds ORDER BY id DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $tiktoks = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    $tiktoks = [];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        /* --- GLOBAL STYLES --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            /* Reduced top padding to bring content closer to header */
            padding-top: 100px; 
            padding-bottom: 80px;
        }

        /* --- UPDATED CONTAINER STYLES --- */
        .glass-container {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            
            /* Reduced margin to close the gap */
            margin-top: 10px; 
            margin-bottom: 40px;
            
            /* WIDTH SETTINGS */
            width: 95%; 
            max-width: 1600px; 
            margin-left: auto;
            margin-right: auto;
        }

        .page-title {
            text-align: center;
            font-weight: 600;
            margin-bottom: 30px;
            color: #FFC107;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
            font-size: 2.5rem;
        }

        /* --- LIVE STREAM PLACEHOLDER --- */
        .live-placeholder-wrapper {
            background: #000;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(255, 193, 7, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
        }
        
        .placeholder-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background: radial-gradient(circle, rgba(26,35,126,1) 0%, rgba(0,0,0,1) 100%);
            height: 100%;
            width: 100%;
        }

        .play-icon { font-size: 4rem; }

        /* --- GOOGLE ADS PLACEHOLDERS --- */
        .ad-placeholder {
            background: rgba(0, 0, 0, 0.2);
            border: 1px dashed rgba(255, 255, 255, 0.3);
            display: flex;
            justify-content: center;
            align-items: center;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.9rem;
            border-radius: 8px;
            overflow: hidden;
            text-align: center;
        }

        /* Top Ad (Leaderboard) */
        .ad-top {
            width: 100%;
            height: 90px;
            margin-bottom: 20px;
        }

        /* Side Ads (Skyscraper) */
        .ad-vertical {
            width: 100%;
            height: 100%;
            min-height: 400px; 
        }

        /* --- TIKTOK FEED STYLES --- */
        .tiktok-card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 600px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
            width: 100%;
        }

        .tiktok-card blockquote.tiktok-embed {
            min-width: unset !important;
            max-width: 100% !important;
            width: 100% !important;
            margin: 0 !important;
        }

        /* --- PAGINATION --- */
        .pagination .page-link {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin: 0 5px;
            border-radius: 5px;
        }
        .pagination .page-item.active .page-link {
            background: #FFC107;
            color: #1A237E;
            border-color: #FFC107;
        }
        .pagination .page-link:hover {
            background: #FFC107;
            color: #1A237E;
        }

        /* ========================================= */
        /* MOBILE OPTIMIZATION                       */
        /* ========================================= */
        @media (max-width: 991px) {
            .ad-vertical {
                min-height: 250px;
                margin-top: 15px;
            }
        }

        @media (max-width: 768px) {
            body { padding-top: 90px; padding-bottom: 40px; }
            .glass-container { width: 95%; padding: 15px; margin-top: 10px; }
            .page-title { font-size: 1.8rem; margin-bottom: 20px; }
            .tiktok-card { min-height: 500px; }
            .play-icon { font-size: 3rem; }
            .placeholder-content h3 { font-size: 1.2rem; }
        }
    </style>
</head>
<body>

<div class="container-fluid p-0">
    <div class="glass-container">
        
        <!--<div class="row justify-content-center">-->
        <!--    <div class="col-12 col-lg-10">-->
        <!--        <div class="ad-placeholder ad-top">-->
        <!--            <span>Google Ad (Top Leaderboard)</span>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->

        <div class="row mb-4 mb-md-5 align-items-center">
            
            <!--<div class="col-12 col-lg-2 order-2 order-lg-1">-->
            <!--    <div class="ad-placeholder ad-vertical">-->
            <!--        <span>Left Ad<br>(160x600)</span>-->
            <!--    </div>-->
            <!--</div>-->

            <div class="col-12 col-lg-8 order-1 order-lg-2"> 
                <!--<div class="live-placeholder-wrapper">-->
                <!--    <div class="ratio ratio-16x9">-->
                        
                <!--        <div class="placeholder-content text-center px-3">-->
                <!--            <i class="bi bi-play-circle-fill text-warning play-icon"></i>-->
                <!--            <h3 class="mt-3 text-white">Live Stream Coming Soon</h3>-->
                <!--            <p class="text-white-50 small">Stay tuned for the live event broadcast.</p>-->
                <!--        </div>-->

                <!--    </div>-->
                <!--</div>-->
            </div>

            <!--<div class="col-12 col-lg-2 order-3 order-lg-3">-->
            <!--    <div class="ad-placeholder ad-vertical">-->
            <!--        <span>Right Ad<br>(160x600)</span>-->
            <!--    </div>-->
            <!--</div>-->

        </div>

        <h1 class="page-title">Ridee Reyak TikTok Feed</h1>
        
        <div class="row g-3 g-md-4 justify-content-center">
            <?php if (!empty($tiktoks)): ?>
                <?php foreach ($tiktoks as $tk): ?>
                    <div class="col-12 col-md-6 col-lg-4"> 
                        <div class="tiktok-card">
                            <?php echo $tk['embed_code']; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center">
                    <p>No TikToks found.</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation" class="mt-4 mt-md-5">
                <ul class="pagination justify-content-center flex-wrap">
                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                    </li>

                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>

                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script async src="https://www.tiktok.com/embed.js"></script>

</body>
</html>

<?php require '../components/footer.php'; ?>