<div class="split-layout-container">
    <div class="split-left">
        <?php require 'components/featured_programs.php'; ?>
    </div>
    <div class="split-right">
        <?php require 'components/facebook_feed.php'; ?>
    </div>
</div>

<style>
    .split-layout-container {
        display: flex; /* ✅ Make children side by side */
        width: 100%;
        max-width: 1200px; /* Matches banner slider and video player */
        margin: 40px auto;
        padding: 20px;
        gap: 20px; /* Space between sections */
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(5px);
        -webkit-backdrop-filter: blur(5px);
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        color: white;
    }

    .split-left {
        flex: 2; /* 2/3 of the width */
        border-radius: 20px;
        padding: 20px;
        min-height: 300px;
    }

    .split-right {
        flex: 1; /* 1/3 of the width */
        border-radius: 20px;
        padding: 20px;
        min-height: 300px;
    }

    /* Responsive adjustments */
    @media (max-width: 991px) {
        .split-layout-container {
            flex-direction: column; /* Stack vertically on smaller screens */
            margin: 15px auto;
            gap: 15px;
        }
        .split-left, .split-right {
            border-radius: 15px;
            min-height: 200px;
        }
    }

    @media (max-width: 576px) {
        .split-layout-container {
            margin: 10px auto;
            gap: 10px;
        }
        .split-left, .split-right {
            border-radius: 10px;
            min-height: 150px;
            padding: 15px;
        }
    }
</style>
