<?php
$page_title = "Ridee Reyak | Swarnawahini"; 
require_once '../config.php';
require '../components/db_connect.php';
require '../components/header.php';

// -----------------------------------------
// PAGINATION LOGIC
// -----------------------------------------
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

// CHANGED: Increased to 8 so we have 2 full rows of 4 items
$items_per_page = 8; 
$offset = ($page - 1) * $items_per_page;

$shorts = [];
$total_pages = 1;

try {
    $count_stmt = $conn->query("SELECT COUNT(*) FROM youtube_shorts");
    $total_items = $count_stmt->fetchColumn();
    $total_pages = ceil($total_items / $items_per_page);

    $stmt = $conn->prepare("SELECT * FROM youtube_shorts ORDER BY published_at DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $shorts = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-YOUR_ID_HERE" crossorigin="anonymous"></script>

    <style>
        /* --- GLOBAL LAYOUT --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            padding-top: 100px; 
            padding-bottom: 80px;
        }

        .glass-container {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin-top: 10px; 
            margin-bottom: 40px;
            width: 98%; 
            max-width: 1800px; 
            margin-left: auto;
            margin-right: auto;
        }

        .page-title {
            text-align: center;
            font-weight: 600;
            margin-bottom: 30px;
            color: #FFC107;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
            font-size: 2.5rem;
        }

        /* --- GOOGLE ADS --- */
        .ad-placeholder {
            /* Placeholder styling - remove class when real ads are live */
            background: rgba(0, 0, 0, 0.2);
            border: 1px dashed rgba(255, 255, 255, 0.3);
            display: flex; 
            justify-content: center; 
            align-items: center;
            border-radius: 8px; 
            overflow: hidden;
        }
        .ad-top { width: 100%; height: 90px; margin-bottom: 20px; }
        .ad-vertical { width: 100%; height: 100%; min-height: 400px; }

        /* --- LIVE STREAM PLAYER --- */
        .live-placeholder-wrapper {
            background: #000;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(255, 193, 7, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .placeholder-content {
            background: radial-gradient(circle, rgba(26,35,126,1) 0%, rgba(0,0,0,1) 100%);
            display: flex; flex-direction: column; justify-content: center; align-items: center; height: 100%;
        }

        /* --- YOUTUBE SHORTS CARD (VERTICAL) --- */
        .shorts-card {
            background: #000;
            border-radius: 15px;
            overflow: hidden;
            position: relative;
            width: 100%;
            /* 9:16 Aspect Ratio Magic */
            aspect-ratio: 9 / 16; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.3);
            transition: transform 0.3s ease;
            border: 1px solid rgba(255,255,255,0.1);
        }
        .shorts-card:hover {
            transform: scale(1.02);
            border-color: #FFC107;
        }
        .shorts-card iframe {
            position: absolute;
            top: 0; left: 0;
            width: 100%;
            height: 100%;
            border: none;
        }

        /* --- PAGINATION --- */
        .pagination .page-link {
            background: rgba(255, 255, 255, 0.1); color: white; border: 1px solid rgba(255, 255, 255, 0.2); margin: 0 5px; border-radius: 5px;
        }
        .pagination .page-item.active .page-link, .pagination .page-link:hover {
            background: #FFC107; color: #1A237E; border-color: #FFC107;
        }

        /* --- MOBILE --- */
        @media (max-width: 991px) {
            .ad-vertical { min-height: 250px; margin-top: 15px; }
        }
        @media (max-width: 768px) {
            body { padding-top: 90px; }
            .page-title { font-size: 1.8rem; }
        }
    </style>
</head>
<body>

<div class="container-fluid p-0">
    <div class="glass-container">
        
        <!--<div class="row justify-content-center">-->
        <!--    <div class="col-12 col-lg-10">-->
        <!--        <div class="ad-placeholder ad-top">-->
        <!--            <span>Google Ad (Top Leaderboard)</span>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->

        <div class="row mb-5 align-items-center">
            
            <!--<div class="col-12 col-lg-2 order-2 order-lg-1">-->
            <!--    <div class="ad-placeholder ad-vertical">-->
            <!--        <span>Left Ad (160x600)</span>-->
            <!--    </div>-->
            <!--</div>-->

            <!--<div class="col-12 col-lg-8 order-1 order-lg-2"> -->
            <!--    <div class="live-placeholder-wrapper">-->
            <!--        <div class="ratio ratio-16x9">-->
            <!--            <div class="placeholder-content text-center px-3">-->
            <!--                <i class="bi bi-play-circle-fill text-warning" style="font-size: 4rem;"></i>-->
            <!--                <h3 class="mt-3 text-white">Live Stream Coming Soon</h3>-->
            <!--                <p class="text-white-50 small">Stay tuned for the event.</p>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->

            <div class="col-12 col-lg-2 order-3 order-lg-3">
            <!--    <div class="ad-placeholder ad-vertical">-->
            <!--        <span>Right Ad (160x600)</span>-->
            <!--    </div>-->
            <!--</div>-->
        </div>

        <h1 class="page-title">Latest Shorts</h1>
        
        <div class="row g-4 justify-content-center">
            <?php if (!empty($shorts)): ?>
                <?php foreach ($shorts as $short): ?>
                    
                    <div class="col-12 col-sm-6 col-lg-3"> 
                        <div class="shorts-card">
                            <iframe 
                                src="https://www.youtube.com/embed/<?php echo $short['video_id']; ?>?rel=0&modestbranding=1&playsinline=1" 
                                title="<?php echo htmlspecialchars($short['title']); ?>" 
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                                allowfullscreen>
                            </iframe>
                        </div>
                    </div>

                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center py-5">
                    <p class="text-white-50">No shorts available yet. Please sync from Admin Dashboard.</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation" class="mt-5">
                <ul class="pagination justify-content-center flex-wrap">
                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                    </li>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php require '../components/footer.php'; ?>