<?php
$page_title = "Special Programmes | Swarnawahini"; 
require_once '../config.php';
require '../components/db_connect.php';

// -----------------------------------------
// PHP LOGIC (Data Fetching)
// -----------------------------------------

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$items_per_page = 4; 
$offset = ($page - 1) * $items_per_page;

$shows = [];
$total_pages = 1;

try {
    $count_stmt = $conn->query("SELECT COUNT(*) FROM special_embeds");
    $total_items = $count_stmt->fetchColumn();
    $total_pages = ceil($total_items / $items_per_page);

    $stmt = $conn->prepare("SELECT * FROM special_embeds ORDER BY id DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $shows = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    $shows = [];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        /* --- GLOBAL STYLES --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            padding-top: 100px; 
            padding-bottom: 80px;
        }

        /* --- CONTAINER STYLES --- */
        .glass-container {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin-top: 40px; 
            margin-bottom: 40px;
            width: 99%; 
            max-width: 100%; 
            margin-left: auto;
            margin-right: auto;
            position: relative;
            z-index: 1; 
        }

        .page-title {
            text-align: center;
            font-weight: 600;
            margin-bottom: 40px;
            color: #FFC107;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
            font-size: 2.5rem;
        }

        /* --- CARD STYLES --- */
        .video-card {
            background: rgba(0, 0, 0, 0.4); 
            border-radius: 8px;
            overflow: hidden;
            padding: 0;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 4px 20px rgba(0,0,0,0.4);
            margin-bottom: 40px; 
            /* REMOVED: Hover transition and transform */
        }

        /* --- THUMBNAIL COVER --- */
        .custom-thumb-wrapper {
            position: relative;
            width: 100%;
            padding-bottom: 56.25%; /* 16:9 Aspect Ratio */
            background: #000;
            cursor: pointer;
            overflow: hidden;
        }

        .custom-thumb-wrapper img {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            /* REMOVED: Transition effect */
        }

        /* REMOVED: .custom-thumb-wrapper:hover img { transform: scale... } */

        .play-overlay {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: #FFC107;
            font-size: 6rem;
            z-index: 10;
            text-shadow: 0 4px 20px rgba(0,0,0,0.8);
            pointer-events: none;
            transition: transform 0.2s ease; /* Only button moves slightly on click */
        }
        
        /* Optional: Subtle button press effect */
        .custom-thumb-wrapper:active .play-overlay {
            transform: translate(-50%, -50%) scale(0.9);
        }

        /* --- VIDEO WRAPPER --- */
        .generic-video-wrapper {
            position: relative;
            width: 100%;
            padding-bottom: 56.25%; 
            height: 0;
            background: #000;
        }

        .generic-video-wrapper iframe,
        .generic-video-wrapper object,
        .generic-video-wrapper embed,
        .generic-video-wrapper video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100% !important;
            height: 100% !important;
            border: none;
        }

        .d-none { display: none !important; }

        .video-card-body {
            padding: 25px;
            background: rgba(255, 255, 255, 0.05);
            text-align: left;
        }

        .video-title {
            font-size: 1.8rem;
            color: #fff;
            margin: 0;
            font-weight: 600;
            white-space: normal;
        }

        /* --- PAGINATION --- */
        .pagination .page-link {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin: 0 5px;
            border-radius: 5px;
        }
        .pagination .page-item.active .page-link {
            background: #FFC107;
            color: #1A237E;
            border-color: #FFC107;
        }
        .pagination .page-link:hover {
            background: #FFC107;
            color: #1A237E;
        }

        @media (max-width: 768px) {
            body { padding-top: 100px; padding-bottom: 40px; }
            .glass-container { width: 95%; padding: 15px; margin-top: 20px; }
            .page-title { font-size: 1.8rem; margin-bottom: 20px; }
            .play-overlay { font-size: 3rem; }
            .video-title { font-size: 1.2rem; }
        }
    </style>
</head>
<body>

<?php require '../components/header.php'; ?>

<div class="container-fluid p-0">
    <div class="glass-container">
        
        <h1 class="page-title">Special Programmes</h1>
        
        <div class="row g-4 justify-content-center">
            <?php if (!empty($shows)): ?>
                <?php foreach ($shows as $row): ?>
                    <div class="col-12"> 
                        <div class="video-card">
                            
                            <?php if (!empty($row['thumbnail_url'])): ?>
                                <div class="custom-thumb-wrapper" id="thumb-<?php echo $row['id']; ?>" onclick="playEmbed(<?php echo $row['id']; ?>)">
                                    <img src="/Uploads/embeds/<?php echo htmlspecialchars($row['thumbnail_url']); ?>" alt="<?php echo htmlspecialchars($row['title']); ?>">
                                    <div class="play-overlay">
                                        <i class="bi bi-play-circle-fill"></i>
                                    </div>
                                </div>

                                <div class="generic-video-wrapper d-none" id="embed-<?php echo $row['id']; ?>">
                                    <?php echo $row['embed_code']; ?>
                                </div>

                            <?php else: ?>
                                <div class="generic-video-wrapper">
                                    <?php echo $row['embed_code']; ?>
                                </div>
                            <?php endif; ?>

                            <div class="video-card-body">
                                <h5 class="video-title" title="<?php echo htmlspecialchars($row['title']); ?>">
                                    <?php echo htmlspecialchars($row['title']); ?>
                                </h5>
                            </div>

                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center py-5">
                    <i class="bi bi-collection-play" style="font-size: 4rem; color: rgba(255,255,255,0.3);"></i>
                    <p class="mt-3 text-white-50">No special programmes added yet.</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation" class="mt-5">
                <ul class="pagination justify-content-center flex-wrap">
                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                    </li>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function playEmbed(id) {
        // 1. Hide the thumbnail
        const thumb = document.getElementById('thumb-' + id);
        if (thumb) thumb.classList.add('d-none');

        // 2. Show the embed container
        const embedContainer = document.getElementById('embed-' + id);
        if (embedContainer) {
            embedContainer.classList.remove('d-none');

            // 3. Find the iframe inside and force Autoplay
            const iframe = embedContainer.querySelector('iframe');
            if (iframe) {
                let src = iframe.getAttribute('src');
                
                // Only add autoplay if it's not already there
                if (src && !src.includes('autoplay=1')) {
                    // Check if URL already has parameters (use &) or not (use ?)
                    const separator = src.includes('?') ? '&' : '?';
                    
                    // Add autoplay parameter
                    // Note: 'mute=0' often helps autoplay work, but some browsers block sound.
                    // We try to autoplay with sound.
                    iframe.setAttribute('src', src + separator + "autoplay=1");
                }
            }
        }
    }
</script>

</body>
</html>

<?php require '../components/footer.php'; ?>