<?php
session_start();
require $_SERVER['DOCUMENT_ROOT'] . '/components/db_connect.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $conn->prepare("SELECT * FROM programmes WHERE id=:id");
$stmt->execute([':id' => $id]);
$programme = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$programme) {
    die("Programme not found.");
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = filter_input(INPUT_POST, 'programme_title', FILTER_SANITIZE_STRING);
    $description = filter_input(INPUT_POST, 'description', FILTER_SANITIZE_STRING);
    $youtube_playlist = filter_input(INPUT_POST, 'youtube_playlist', FILTER_SANITIZE_STRING);
    $cover_image = $programme['cover_image'];

    if (isset($_FILES['cover_image']) && $_FILES['cover_image']['error'] === UPLOAD_ERR_OK) {
        $target_dir = $_SERVER['DOCUMENT_ROOT'] . '/uploads/programmes/';
        $cover_image = basename($_FILES['cover_image']['name']);
        $target_file = $target_dir . $cover_image;
        move_uploaded_file($_FILES['cover_image']['tmp_name'], $target_file);
    }

    $stmt = $conn->prepare("UPDATE programmes SET title=:title, description=:description, youtube_playlist=:youtube_playlist, cover_image=:cover_image WHERE id=:id");
    $stmt->execute([
        ':title' => $title,
        ':description' => $description,
        ':youtube_playlist' => $youtube_playlist,
        ':cover_image' => $cover_image,
        ':id' => $id
    ]);

    $message = "Programme updated successfully!";
    $programme['title'] = $title;
    $programme['description'] = $description;
    $programme['youtube_playlist'] = $youtube_playlist;
    $programme['cover_image'] = $cover_image;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Programme</title>
    <link rel="stylesheet" href="/css/bootstrap.min.css">
</head>
<body class="container py-4">
    <h2>Edit Programme</h2>
    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo $message; ?></div>
    <?php endif; ?>
    <form method="POST" enctype="multipart/form-data">
        <div class="mb-3">
            <label for="programme_title" class="form-label">Title</label>
            <input type="text" id="programme_title" name="programme_title" class="form-control" value="<?php echo htmlspecialchars($programme['title']); ?>" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea id="description" name="description" class="form-control" rows="3"><?php echo htmlspecialchars($programme['description']); ?></textarea>
        </div>
        <div class="mb-3">
            <label for="youtube_playlist" class="form-label">YouTube Playlist ID</label>
            <input type="text" id="youtube_playlist" name="youtube_playlist" class="form-control" value="<?php echo htmlspecialchars($programme['youtube_playlist']); ?>" required>
        </div>
        <div class="mb-3">
            <label for="cover_image" class="form-label">Cover Image</label>
            <input type="file" id="cover_image" name="cover_image" class="form-control" accept="image/*">
            <?php if ($programme['cover_image']): ?>
                <img src="/uploads/programmes/<?php echo htmlspecialchars($programme['cover_image']); ?>" width="120" class="mt-2">
            <?php endif; ?>
        </div>
        <button type="submit" class="btn btn-success">Update Programme</button>
        <a href="admin_dashboard.php#programme" class="btn btn-secondary">Back</a>
    </form>
</body>
</html>
