<?php
/*
 * HORIZONTAL AD COMPONENT (WITH SCHEDULER)
 *
 * Logic:
 * - 1 Ad → Centered
 * - 2 Ads → Centered with spacing
 * - 3 Ads → Spread evenly
 * - Scheduling: Checks start_date and end_date against NOW()
 */
?>

<style>
/* === CONTAINER ALIGNMENT === */
.horizontal-ad-container {
    width: 100%;
    max-width: 1200px;
    margin: 10px auto;
    padding: 0;
    background: transparent;
    overflow: hidden;
}

/* === FLEX ROW === */
.horizontal-ad-container .ad-row {
    display: flex;
    flex-wrap: wrap;
    justify-content: center; /* default center */
    width: 100%;
    margin: 0 -5px;
}

/* === COLUMNS === */
.horizontal-ad-container .ad-column {
    flex: 0 0 33.333%;
    width: 33.333%;
    padding: 0 5px;
}

/* === AD ITEM === */
.horizontal-ad-item {
    max-width: 400px;
    height: 60px;
    margin: 0 auto;
    background: #f0f0f0;
    overflow: hidden;
    border-radius: 10px;
}

.horizontal-ad-item a {
    display: block;
    width: 100%;
    height: 100%;
}

.horizontal-ad-item img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}

/* === RESPONSIVE === */
@media (max-width: 767px) {
    .horizontal-ad-container .ad-row {
        flex-direction: column;
        align-items: center;
        margin: 0;
        padding: 0;
        gap: 10px !important; /* smaller gap for mobile */
    }
    .horizontal-ad-container .ad-column {
        width: 100%;
        padding: 0;
        margin: 0;
    }
    .horizontal-ad-item {
        max-width: 400px;
    }
}
</style>

<?php
// === FETCH ADS FROM DATABASE WITH SCHEDULING ===
$horizontal_ads = [];
try {
    if (isset($conn)) {
        // SQL LOGIC EXPLAINED:
        // 1. (start_date IS NULL OR start_date <= NOW()) -> Ad has started or has no start time (runs immediately)
        // 2. AND
        // 3. (end_date IS NULL OR end_date >= NOW())     -> Ad has not ended or has no end time (runs forever)
        
        $sql = "SELECT * FROM horizontal_ads 
                WHERE 
                    (start_date IS NULL OR start_date <= NOW()) 
                AND 
                    (end_date IS NULL OR end_date >= NOW()) 
                ORDER BY RAND() 
                LIMIT 3";

        $stmt = $conn->query($sql);
        if ($stmt) {
            $horizontal_ads = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
} catch (Exception $e) {
    // Ideally log this to a file instead of showing user, but keeping simple for now
    error_log("Error fetching horizontal ads: " . $e->getMessage());
}

$ad_count = count($horizontal_ads);
?>

<?php if ($ad_count > 0): ?>
    <div class="horizontal-ad-container">
        <div class="ad-row" 
            style="
                <?php 
                    if ($ad_count === 1) echo 'justify-content:center;';
                    elseif ($ad_count === 2) echo 'justify-content:center; gap:40px;';
                    else echo 'justify-content:space-between;';
                ?>
            ">
            <?php foreach ($horizontal_ads as $ad): ?>
                <div class="ad-column" style="<?php echo $ad_count < 3 ? 'flex:0 0 auto; width:auto;' : ''; ?>">
                    <div class="horizontal-ad-item">
                        <a href="<?php echo htmlspecialchars($ad['link_url'] ?? '#'); ?>" target="_blank" rel="noopener noreferrer">
                            <img src="<?php echo BASE_URL; ?>Uploads/ads/<?php echo htmlspecialchars($ad['image_path']); ?>" alt="Advertisement">
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>