<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live at Sri Lanka Iframe</title>
   
    <style>
        /* Banner Section */
        .special-program-banner {
            max-width: 1200px;
            margin: 0 auto;
            margin-bottom: 5rem;
            background: transparent !important; /* Ensure transparent background */
            /* If you know your website's background, set it here, e.g.:
               background-color: #f0f0f0 !important;
               or
               background-image: url('path/to/image.jpg') !important;
               background-size: cover !important;
            */
        }

        /* Glassmorphism Effect */
        .glass-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 20px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            padding-bottom: 56.25%; /* 16:9 aspect ratio */
            height: 0;
        }

        /* Hover Effects */
        .glass-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
        }

        /* Iframe Styling */
        .glass-card iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0;
        }

        /* Responsive Adjustments */
        @media (max-width: 767px) {
            .special-program-banner {
                border-radius: 15px;
            }
            .glass-card {
                border-radius: 15px;
            }
        }

        @media (max-width: 576px) {
            .special-program-banner {
                border-radius: 10px;
            }
            .glass-card {
                border-radius: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Banner Section -->
     
    <div class="special-program-banner position-relative mx-auto">
        <div class="glass-card">
            
            <iframe 
                src="https://liveatsrilanka.lk/" 
                title="Live at Sri Lanka Website" 
                allowfullscreen 
                loading="lazy">
            </iframe>
        </div>
    </div>
</body>
</html>