<?php
$page_title = "Privacy Policy | Swarnawahini"; 

require_once '../config.php';
require '../components/header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        /* --- GLOBAL STYLES --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            padding-top: 120px; 
            padding-bottom: 80px;
        }

        /* --- GLASS CONTAINER --- */
        .glass-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 40px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: #ecf0f1;
        }

        .page-title {
            text-align: center;
            font-weight: 600;
            margin-bottom: 40px;
            color: #FFC107;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            font-size: 2.5rem;
        }

        /* --- TEXT STYLES --- */
        h2 {
            color: #FFC107;
            font-size: 1.5rem;
            margin-top: 30px;
            margin-bottom: 15px;
            font-weight: 600;
        }

        p, li {
            font-size: 1rem;
            line-height: 1.8;
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 15px;
        }

        ul {
            padding-left: 20px;
        }

        a {
            color: #FFC107;
            text-decoration: none;
            transition: color 0.3s;
        }

        a:hover {
            color: #ffffff;
            text-decoration: underline;
        }

        .last-updated {
            text-align: center;
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.5);
            margin-bottom: 40px;
        }
    </style>
</head>
<body>

<div class="container px-3">
    <div class="glass-container">
        
        <h1 class="page-title">Privacy Policy</h1>
        <p class="last-updated">Last Updated: <?php echo date("F d, Y"); ?></p>

        <p>Welcome to Swarnawahini. We are committed to protecting your personal information and your right to privacy. If you have any questions or concerns about this privacy notice or our practices with regard to your personal information, please contact us.</p>

        <h2>1. Information We Collect</h2>
        <p>We collect personal information that you voluntarily provide to us when you express an interest in obtaining information about us or our products and services, when you participate in activities on the Website, or otherwise when you contact us.</p>
        <ul>
            <li><strong>Personal Data:</strong> Name, email address, phone number (if you submit a contact form).</li>
            <li><strong>Usage Data:</strong> IP address, browser type, operating system, and pages visited (collected automatically via Google Analytics).</li>
        </ul>

        <h2>2. How We Use Your Information</h2>
        <p>We use personal information collected via our Website for a variety of business purposes described below:</p>
        <ul>
            <li>To respond to user inquiries and offer support.</li>
            <li>To improve user experience and analyze website traffic.</li>
            <li>To serve relevant advertisements.</li>
            <li>To send administrative information to you.</li>
        </ul>

        <h2>3. Advertising Partners</h2>
        
        <p>This Site is affiliated with Monumetric (dba for The Blogger Network, LLC) for the purposes of placing advertising on the Site, and Monumetric will collect and use certain data for advertising purposes. To learn more about Monumetric’s data usage, click here: <a target="_blank" href="http://www.monumetric.com/publisher-advertising-privacy">Publisher Advertising Privacy</a></p>

        <p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google's use of the DART cookie enables it to serve ads to our users based on their visit to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google ad and content network privacy policy.</p>

        <h2>4. Cookies and Tracking Technologies</h2>
        <p>We may use cookies and similar tracking technologies (like web beacons and pixels) to access or store information. Specific information about how we use such technologies and how you can refuse certain cookies is set out in our Cookie Policy.</p>

        <h2>5. Sharing Your Information</h2>
        <p>We strictly do not sell, trade, or rent Users' personal identification information to others. We may share generic aggregated demographic information not linked to any personal identification information regarding visitors and users with our business partners and trusted affiliates.</p>

        <h2>6. Security of Your Information</h2>
        <p>We use administrative, technical, and physical security measures to help protect your personal information. While we have taken reasonable steps to secure the personal information you provide to us, please be aware that despite our efforts, no security measures are perfect or impenetrable.</p>

        <h2>7. Contact Us</h2>
        <p>If you have questions or comments about this policy, you may email us at <a href="mailto:info@swarnawahini.lk">info@swarnawahini.lk</a> 


    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php require '../components/footer.php'; ?>