<?php
// ==========================================
// 1. CONFIGURATION & SEO SETUP
// ==========================================

require_once '../config.php';
require '../components/db_connect.php';

// YOUR VIDEO LINK (5centsCDN)
// Added &autoplay=true &muted=true to ensure it plays automatically
$stream_url = "https://iframes.5centscdn.com/5centscdn/auto/skin1/0yu9oyimz3zhgmqw/aHR0cHM6Ly9tMnFhbDY1eWFqZGctaGxzLXB1c2guNWNlbnRzY2RuLmNvbS9tcDQvbXA0L1JpZGVlUmF5YWsyMDI1L1JSRkhEXzEwODBwLnNtaWwvcGxheWxpc3QubTN1OA==?showcv=true&autoplay=true&muted=true";

// YOUR THUMBNAIL (Shows while video is loading)
$thumbnail_url = "https://www.swarnavahini.lk/Uploads/thumbnail_1000020307.webp";

// SEO VARIABLES
$page_title = "Watch Ridee Reyak 2025 | Full Event | Swarnavahini";
$page_description = "Watch the full event of Ridee Reyak 2025 on Swarnavahini. The ultimate Sri Lankan musical extravaganza featuring the biggest stars is now available to stream.";
$page_keywords = "Ridee Reyak 2025 Full Video, Ridee Reyak Replay, Swarnavahini Ridee Reyak, Sri Lankan Teledrama Awards, Sinhala Musical Show";
$page_url = "https://www.swarnavahini.lk/pages/rideereyak.php";

// ==========================================
// PAGINATION LOGIC
// ==========================================
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$items_per_page = 8; 
$offset = ($page - 1) * $items_per_page;
$shorts = [];
$total_pages = 1;

try {
    $count_stmt = $conn->query("SELECT COUNT(*) FROM youtube_shorts");
    $total_items = $count_stmt->fetchColumn();
    $total_pages = ceil($total_items / $items_per_page);
    $stmt = $conn->prepare("SELECT * FROM youtube_shorts ORDER BY published_at DESC LIMIT :limit OFFSET :offset");
    $stmt->bindValue(':limit', $items_per_page, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $shorts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
}

require '../components/header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    <meta name="keywords" content="<?php echo $page_keywords; ?>">
    <link rel="canonical" href="<?php echo $page_url; ?>">
    <meta name="robots" content="index, follow">

    <meta property="og:type" content="video.movie">
    <meta property="og:title" content="<?php echo $page_title; ?>">
    <meta property="og:description" content="<?php echo $page_description; ?>">
    <meta property="og:url" content="<?php echo $page_url; ?>">
    <meta property="og:image" content="<?php echo $thumbnail_url; ?>">
    <meta property="og:site_name" content="Swarnavahini">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $page_title; ?>">
    <meta name="twitter:description" content="<?php echo $page_description; ?>">
    <meta name="twitter:image" content="<?php echo $thumbnail_url; ?>">

    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "VideoObject",
      "name": "Ridee Reyak 2025 Full Event",
      "description": "<?php echo $page_description; ?>",
      "thumbnailUrl": ["<?php echo $thumbnail_url; ?>"],
      "uploadDate": "2025-12-30T22:00:00+05:30",
      "contentUrl": "<?php echo $stream_url; ?>",
      "embedUrl": "<?php echo $page_url; ?>",
      "publisher": { "@type": "Organization", "name": "Swarnavahini", "logo": { "@type": "ImageObject", "url": "https://www.swarnavahini.lk/assets/images/logo.png" } }
    }
    </script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-YOUR_ID_HERE" crossorigin="anonymous"></script>

    <style>
        /* --- GLOBAL STYLES --- */
        body {
            font-family: 'Poppins', sans-serif;
            background: rgb(25, 52, 134);
            color: white;
            min-height: 100vh;
            padding-top: 90px; 
            padding-bottom: 80px;
            overflow-x: hidden;
        }

        /* --- MAIN GLASS CONTAINER --- */
        .glass-container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.2);
            width: 95%; 
            position: relative;
            z-index: 1; 
        }

        .page-title {
            text-align: center;
            font-weight: 600;
            margin-bottom: 30px;
            color: #FFC107;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            font-size: 2rem;
        }

        /* --- VIDEO CONTAINER --- */
        .live-placeholder-wrapper {
            background-color: #000;
            /* Set the Thumbnail as background */
            background-image: url('<?php echo $thumbnail_url; ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(255, 193, 7, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
        }
        
        /* Video Box Styling */
        #live-video-box { width: 100%; height: 100%; }
        
        /* IFRAME FADE-IN EFFECT */
        #live-iframe { 
            width: 100%; 
            height: 100%; 
            opacity: 0; /* Start hidden so thumbnail shows */
            transition: opacity 1.5s ease-in-out; /* Smooth fade in */
        }
        
        /* Class to trigger fade in */
        #live-iframe.visible { opacity: 1; }

        /* SEO Content (Hidden) */
        .seo-content { position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0,0,0,0); white-space: nowrap; border: 0; }

        /* --- ADS --- */
        .ad-placeholder {
            background: rgba(0, 0, 0, 0.2);
            border: 1px dashed rgba(255, 255, 255, 0.3);
            display: flex; 
            justify-content: center; 
            align-items: center;
            border-radius: 8px; 
            overflow: hidden;
        }
        .ad-top { width: 100%; height: 90px; margin-bottom: 20px; }
        .ad-vertical { width: 100%; height: 100%; min-height: 400px; }

        /* --- SHORTS CARD --- */
        .shorts-card {
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(20px) saturate(200%);
            -webkit-backdrop-filter: blur(20px) saturate(200%);
            border: 1px solid rgba(255, 255, 255, 0.15);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            border-radius: 20px;
            background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.15) 0%, rgba(255, 255, 255, 0.02) 100%);
            overflow: hidden;
            position: relative;
            width: 100%;
            aspect-ratio: 9 / 16; 
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .shorts-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.4);
            border-color: #FFC107;
        }
        .shorts-card iframe {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: none;
        }

        /* --- PAGINATION --- */
        .pagination { margin-top: 2rem; display: flex; justify-content: center; gap: 0.5rem; }
        .pagination .page-link {
            color: #1A237E; background-color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0, 25, 118, 0.2); padding: 8px 15px; min-width: 40px; text-align: center; border-radius: 50px;
            transition: background-color 0.3s ease, transform 0.3s ease; text-decoration: none; display: inline-flex; align-items: center; justify-content: center;
        }
        .pagination .page-item.active .page-link { background-color: #FFC107; color: #1A237E; border-color: #FFC107; transform: scale(1.1); }
        .pagination .page-link:hover { background-color: #ff0000; color: #ffffff; transform: scale(1.05); }

        @media (max-width: 991px) {
            .glass-container { border-radius: 10px; }
            .ad-vertical { min-height: 250px; margin-top: 15px; }
            .page-title { font-size: 1.5rem; }
            .time-val { font-size: 1.8rem; }
            .time-box { min-width: 60px; padding: 10px; }
        }
    </style>
</head>
<body>

<div class="seo-content">
    <h1>Watch Ridee Reyak 2025 Full Event</h1>
    <p>Enjoy the full recorded stream of Ridee Reyak 2025 on Swarnavahini. The biggest musical show in Sri Lanka.</p>
</div>

<div class="container-fluid p-0">
    <div class="glass-container">
        
        <div class="row mb-5 align-items-center justify-content-center">
            
            <div class="col-12 col-lg-8 order-1 order-lg-2"> 
                <div class="live-placeholder-wrapper">
                    <div class="ratio ratio-16x9">
                        
                        <div id="live-video-box">
                            <iframe 
                                id="live-iframe" 
                                src="<?php echo $stream_url; ?>"
                                frameborder="0" 
                                scrolling="no"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                                allowfullscreen>
                            </iframe>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <h2 class="page-title">Latest Shorts</h2>
        
        <div class="row g-4 justify-content-center">
            <?php if (!empty($shorts)): ?>
                <?php foreach ($shorts as $short): ?>
                    <div class="col-12 col-sm-6 col-lg-3"> 
                        <div class="shorts-card">
                            <iframe 
                                src="https://www.youtube.com/embed/<?php echo $short['video_id']; ?>?rel=0&modestbranding=1&playsinline=1" 
                                title="<?php echo htmlspecialchars($short['title']); ?>" 
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                                allowfullscreen>
                            </iframe>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 text-center py-5">
                    <p class="text-white-50">No shorts available yet.</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation">
                <ul class="pagination">
                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                    </li>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // --- VIDEO FADE IN SCRIPT ---
    // This script waits 1.5 seconds (to allow iframe to initialize)
    // and then fades the video in over the thumbnail.
    document.addEventListener("DOMContentLoaded", function() {
        const iframe = document.getElementById('live-iframe');
        
        // Method 1: On Load (Best for fast connections)
        iframe.onload = function() {
            setTimeout(function() {
                iframe.classList.add('visible');
            }, 500); // Small delay to prevent black flash
        };

        // Method 2: Fallback Timeout (In case onload misses)
        setTimeout(function() {
            iframe.classList.add('visible');
        }, 3000); // Force show after 3 seconds anyway
    });
</script>

</body>
</html>

<?php require '../components/footer.php'; ?>