<?php
// 1. Include Config (Note the ../ to go back one folder from 'admin')
include '../config/config.php';

// 2. Check Authentication & Role
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

// 3. Fetch Statistics for the Dashboard
// Get total dramas
$total_dramas = $pdo->query("SELECT COUNT(*) FROM dramas")->fetchColumn();
// Get total members
$total_members = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'member'")->fetchColumn();
// Get total ratings submitted
$total_ratings = $pdo->query("SELECT COUNT(*) FROM ratings")->fetchColumn();

// 4. Fetch Recent Activity
$recent_ratings = $pdo->query("SELECT r.*, u.full_name, e.ep_number, d.title 
                               FROM ratings r 
                               JOIN users u ON r.user_id = u.id 
                               JOIN episodes e ON r.episode_id = e.id 
                               JOIN dramas d ON e.drama_id = d.id 
                               ORDER BY r.created_at DESC LIMIT 5")->fetchAll();

include '../includes/header.php'; 
?>

<div class="container mt-4">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2 class="fw-bold text-white">Admin Dashboard</h2>
            <p class="text-white-50">Welcome back, <?= $_SESSION['full_name'] ?></p>
        </div>
    </div>

    <div class="row g-3 mb-5">
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 text-center">
                <h1 class="text-danger fw-bold mb-0"><?= $total_dramas ?></h1>
                <small class="text-muted text-uppercase">Total Dramas</small>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 text-center">
                <h1 class="text-danger fw-bold mb-0"><?= $total_members ?></h1>
                <small class="text-muted text-uppercase">Committee Members</small>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 text-center">
                <h1 class="text-danger fw-bold mb-0"><?= $total_ratings ?></h1>
                <small class="text-muted text-uppercase">Total Evaluations</small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary bg-transparent">
                    <h5 class="mb-0 text-white">Recent Evaluations</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0">
                            <thead>
                                <tr class="text-muted small text-uppercase">
                                    <th>Member</th>
                                    <th>Drama</th>
                                    <th>Ep</th>
                                    <th>Score</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($recent_ratings as $row): ?>
                                <tr>
                                    <td><?= $row['full_name'] ?></td>
                                    <td><?= $row['title'] ?></td>
                                    <td><?= $row['ep_number'] ?></td>
                                    <td><span class="badge bg-danger"><?= $row['score'] ?>/10</span></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-body">
                    <h5 class="text-white mb-4">Quick Actions</h5>
                    <div class="d-grid gap-2">
                        <a href="manage_dramas.php" class="btn btn-outline-light text-start py-3">
                            <i class="bi bi-plus-circle me-2"></i> Add New Teledrama
                        </a>
                        <a href="manage_users.php" class="btn btn-outline-light text-start py-3">
                            <i class="bi bi-person-plus me-2"></i> Add Committee Member
                        </a>
                        <a href="reports.php" class="btn btn-danger py-3 fw-bold">
                            <i class="bi bi-file-earmark-bar-graph me-2"></i> View Full Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>