<?php
include '../config/config.php';
$drama_id = (int)$_GET['drama_id'];

// Fetch Drama Info
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$drama_id]);
$drama = $stmt->fetch();

// Fetch Episodes with their specific Average Scores
$ep_stmt = $pdo->prepare("SELECT e.*, AVG(r.score) as ep_avg, COUNT(r.id) as review_count 
                          FROM episodes e 
                          LEFT JOIN ratings r ON e.id = r.episode_id 
                          WHERE e.drama_id = ? 
                          GROUP BY e.id ORDER BY e.ep_number ASC");
$ep_stmt->execute([$drama_id]);
$episodes = $ep_stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <h2 class="text-white fw-bold"><?= $drama['title'] ?> <span class="text-danger">|</span> <small class="text-white-50">Episode Breakdown</small></h2>
    <hr class="border-secondary mb-4">

    <div class="row g-4">
        <?php foreach ($episodes as $ep): 
            $ep_score = round($ep['ep_avg'], 1);
            $ep_badge = ($ep_score >= 7) ? 'text-success' : (($ep_score >= 4) ? 'text-warning' : 'text-danger');
        ?>
        <div class="col-md-6 col-lg-4">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-white">Episode <?= $ep['ep_number'] ?></h5>
                    <span class="<?= $ep_badge ?> fw-bold fs-5"><?= $ep_score ?: 'N/A' ?></span>
                </div>
                <div class="card-body">
                    <h6 class="text-white-50 small mb-3">MEMBER RATINGS:</h6>
                    <ul class="list-group list-group-flush">
                        <?php
                        // Fetch individual member ratings for THIS episode
                        $rat_stmt = $pdo->prepare("SELECT r.*, u.full_name FROM ratings r JOIN users u ON r.user_id = u.id WHERE r.episode_id = ?");
                        $rat_stmt->execute([$ep['id']]);
                        $ratings = $rat_stmt->fetchAll();
                        
                        foreach ($ratings as $r): ?>
                            <li class="list-group-item bg-transparent text-white border-secondary px-0 py-2">
                                <div class="d-flex justify-content-between">
                                    <span class="small"><?= $r['full_name'] ?></span>
                                    <span class="badge bg-secondary"><?= $r['score'] ?>/10</span>
                                </div>
                                <div class="text-muted" style="font-size: 0.75rem;">
                                    Watched: <?= floor($r['watch_time_seconds']/60) ?>m <?= $r['watch_time_seconds']%60 ?>s
                                </div>
                                <p class="mb-0 mt-1 small italic text-white-50">"<?= $r['review_text'] ?>"</p>
                            </li>
                        <?php endforeach; ?>
                        
                        <?php if(empty($ratings)): ?>
                            <li class="list-group-item bg-transparent text-muted px-0">No ratings yet.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>
<?php include '../includes/footer.php'; ?>