<?php
include '../config/config.php';

// 1. Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

// 2. FETCH DATA
// A. Detailed Member Productivity (Ranked by most active)
$member_stats = $pdo->query("SELECT u.id, u.full_name, u.username, u.last_login,
    COUNT(r.id) as total_rated,
    SUM(r.watch_time_seconds) as total_seconds,
    AVG(r.score) as avg_given
    FROM users u
    LEFT JOIN ratings r ON u.id = r.user_id
    WHERE u.role = 'member'
    GROUP BY u.id
    ORDER BY total_rated DESC")->fetchAll();

// B. Calculate System-Wide Averages for Comparison
$total_committee_time = $pdo->query("SELECT SUM(watch_time_seconds) FROM ratings")->fetchColumn();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="row align-items-center mb-4">
        <div class="col-md-6">
            <h2 class="text-white fw-bold mb-0">Committee Audit</h2>
            <p class="text-white-50">Monitoring 10 members and their evaluation productivity</p>
        </div>
        <div class="col-md-6 text-md-end">
            <div class="btn-group shadow">
                <a href="manage_users.php" class="btn btn-danger btn-sm"><i class="bi bi-person-plus me-1"></i> Add Member</a>
                <button onclick="window.print()" class="btn btn-outline-light btn-sm"><i class="bi bi-printer me-1"></i> Print Audit</button>
            </div>
        </div>
    </div>

    <div class="row g-3 mb-5">
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 shadow-sm">
                <small class="text-muted text-uppercase fw-bold">Total Committee Hours</small>
                <h3 class="text-white mb-0"><?= floor($total_committee_time / 3600) ?>h <?= floor(($total_committee_time % 3600) / 60) ?>m</h3>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 shadow-sm border-start border-danger border-4">
                <small class="text-muted text-uppercase fw-bold">Active Members</small>
                <h3 class="text-white mb-0"><?= count($member_stats) ?> <span class="fs-6 text-white-50">/ 10</span></h3>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary shadow-lg">
        <div class="card-header border-secondary bg-transparent py-3">
            <h5 class="text-white mb-0">Productivity & Login Activity</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead class="small text-uppercase text-muted">
                    <tr>
                        <th class="ps-4">Member Name</th>
                        <th>Status</th>
                        <th>Episodes Rated</th>
                        <th>Total Watch Time</th>
                        <th>Avg Score Given</th>
                        <th class="pe-4 text-end">Last Activity</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($member_stats as $ms): 
                        $is_online = (strtotime($ms['last_login']) > strtotime('-15 minutes'));
                        $productivity_color = ($ms['total_rated'] > 0) ? 'text-success' : 'text-muted';
                    ?>
                    <tr>
                        <td class="ps-4">
                            <span class="text-white fw-bold d-block"><?= $ms['full_name'] ?></span>
                            <small class="text-muted">@<?= $ms['username'] ?></small>
                        </td>
                        <td>
                            <?php if($is_online): ?>
                                <span class="badge bg-success small"><i class="bi bi-circle-fill me-1" style="font-size: 7px;"></i> Online</span>
                            <?php else: ?>
                                <span class="badge bg-secondary small">Offline</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <span class="fw-bold me-2"><?= $ms['total_rated'] ?></span>
                                <div class="progress bg-secondary" style="height: 4px; width: 50px;">
                                    <div class="progress-bar bg-danger" style="width: <?= min($ms['total_rated']*5, 100) ?>%"></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="text-info small">
                                <i class="bi bi-clock me-1"></i>
                                <?= floor($ms['total_seconds'] / 60) ?>m <?= $ms['total_seconds'] % 60 ?>s
                            </span>
                        </td>
                        <td class="text-warning fw-bold"><?= $ms['avg_given'] ? round($ms['avg_given'], 1) : '0' ?></td>
                        <td class="pe-4 text-end">
                            <small class="text-white-50">
                                <?= $ms['last_login'] ? date('M d, h:i A', strtotime($ms['last_login'])) : 'Never' ?>
                            </small>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>