<?php
include '../config/config.php';
include '../includes/auth.php'; // Ensures only logged-in members can enter

// Fetch all dramas from the database
$stmt = $pdo->query("SELECT * FROM dramas ORDER BY created_at DESC");
$dramas = $stmt->fetchAll();
?>

<?php include '../includes/header.php'; ?>

<div class="container mt-4">
    <div class="p-5 mb-4 bg-dark rounded-3 shadow-lg border border-secondary">
        <div class="container-fluid py-2">
            <h1 class="display-5 fw-bold text-danger">Welcome, <?= explode(' ', $_SESSION['full_name'])[0] ?>!</h1>
            <p class="col-md-8 fs-5 text-white-50">Review the latest teledrama episodes and submit your internal scores. Your feedback helps maintain our production quality.</p>
        </div>
    </div>

    <h3 class="mb-4 fw-bold"><i class="bi bi-grid-3x3-gap me-2"></i>Available Teledramas</h3>
    
    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 g-4">
        <?php if (count($dramas) > 0): ?>
            <?php foreach ($dramas as $drama): 
                // Count episodes for this drama to show on the card
                $ep_stmt = $pdo->prepare("SELECT COUNT(*) FROM episodes WHERE drama_id = ?");
                $ep_stmt->execute([$drama['id']]);
                $ep_count = $ep_stmt->fetchColumn();
            ?>
            <div class="col">
                <div class="card h-100 drama-card border-0 shadow">
                    <div class="position-relative">
                        <img src="../uploads/thumbnails/<?= $drama['thumbnail'] ?>" class="card-img-top" alt="<?= $drama['title'] ?>" style="height: 280px; object-fit: cover;">
                        <span class="position-absolute top-0 end-0 m-2 badge bg-danger rounded-pill">
                            <?= $ep_count ?> Episodes
                        </span>
                    </div>
                    
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-bold text-white mb-2"><?= $drama['title'] ?></h5>
                        <p class="card-text text-muted small flex-grow-1">
                            <?= substr($drama['description'], 0, 90) ?>...
                        </p>
                        
<div class="mt-3">
    <a href="episodes.php?drama_id=<?= $drama['id'] ?>" class="btn btn-primary w-100 fw-bold">
        <i class="bi bi-play-fill"></i> Browse Episodes
    </a>
</div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12 text-center py-5">
                <i class="bi bi-tv fs-1 text-muted"></i>
                <p class="text-muted mt-3">No teledramas have been added to the system yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>