<?php
include '../config/config.php';
include '../includes/auth.php';

$drama_id = isset($_GET['drama_id']) ? (int)$_GET['drama_id'] : 0;

// 1. Fetch Drama Details
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$drama_id]);
$drama = $stmt->fetch();

if (!$drama) { header("Location: dashboard.php"); exit(); }

// 2. Fetch all episodes for this drama
$ep_stmt = $pdo->prepare("SELECT * FROM episodes WHERE drama_id = ? ORDER BY ep_number ASC");
$ep_stmt->execute([$drama_id]);
$episodes = $ep_stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php" class="text-danger">Dashboard</a></li>
        <li class="breadcrumb-item active text-white" aria-current="page"><?= $drama['title'] ?></li>
      </ol>
    </nav>

    <div class="d-flex align-items-center mb-4">
        <img src="../uploads/thumbnails/<?= $drama['thumbnail'] ?>" class="rounded me-3" style="width: 100px; height: 100px; object-fit: cover; border: 2px solid #333;">
        <div>
            <h2 class="text-white fw-bold mb-0"><?= $drama['title'] ?></h2>
            <p class="text-muted mb-0">Select an episode to start your evaluation</p>
        </div>
    </div>

    <div class="row g-3">
        <?php if (count($episodes) > 0): ?>
            <?php foreach ($episodes as $ep): ?>
                <div class="col-md-3">
                    <div class="card bg-dark border-secondary h-100 hover-shadow">
                        <div class="card-body text-center">
                            <h5 class="text-white mb-3">Episode <?= $ep['ep_number'] ?></h5>
                            <a href="watch.php?id=<?= $ep['id'] ?>" class="btn btn-danger btn-sm px-4 fw-bold">
                                WATCH & RATE
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12 text-center py-5 border border-secondary rounded">
                <p class="text-muted">No episodes have been uploaded for this drama yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>