<?php
// 1. Include Config
include '../config/config.php';

// 2. Check Authentication & Role
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

// 3. Fetch Statistics (Targeting 100pt evaluations)
$total_dramas = $pdo->query("SELECT COUNT(*) FROM dramas")->fetchColumn();
$total_members = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'member'")->fetchColumn();

// Count only the Final Overall Ratings (where episode_id is NULL)
$total_final_evals = $pdo->query("SELECT COUNT(*) FROM ratings WHERE episode_id IS NULL AND score > 0")->fetchColumn();

// 4. Fetch Recent Activity (Final 100.00 Ratings)
$recent_activity = $pdo->query("SELECT r.*, u.full_name, d.title 
                               FROM ratings r 
                               JOIN users u ON r.user_id = u.id 
                               JOIN dramas d ON r.drama_id = d.id 
                               WHERE r.episode_id IS NULL 
                               ORDER BY r.created_at DESC LIMIT 5")->fetchAll();

include '../includes/header.php'; 
?>

<div class="container mt-4 mb-5">
    <div class="row mb-4 align-items-center">
        <div class="col-md-6">
            <h2 class="fw-bold text-white mb-0">Admin Dashboard</h2>
            <p class="text-white-50 small text-uppercase">Production Quality Management</p>
        </div>
        <div class="col-md-6 text-md-end">
            <span class="badge bg-dark border border-secondary p-2">
                <i class="bi bi-calendar3 me-2"></i> <?= date('l, F j, Y') ?>
            </span>
        </div>
    </div>

    <div class="row g-4 mb-5">
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-info">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Total Teledramas</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_dramas ?></h1>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-danger">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Committee Members</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_members ?></h1>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-success">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Final Evaluations</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_final_evals ?></h1>
            </div>
        </div>
    </div>

    

    <div class="row g-4">
        <div class="col-lg-8">
            <div class="card bg-dark border-secondary h-100 shadow">
                <div class="card-header border-secondary bg-black py-3">
                    <h5 class="mb-0 text-white"><i class="bi bi-clipboard-data me-2"></i>Recent 100.00 Evaluations</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr class="text-muted small text-uppercase border-secondary">
                                    <th class="ps-4">Member</th>
                                    <th>Production</th>
                                    <th>Overall Score</th>
                                    <th class="pe-4 text-end">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($recent_activity): foreach($recent_activity as $row): ?>
                                <tr>
                                    <td class="ps-4 py-3">
                                        <span class="fw-bold"><?= htmlspecialchars($row['full_name']) ?></span>
                                    </td>
                                    <td><?= htmlspecialchars($row['title']) ?></td>
                                    <td>
                                        <span class="badge bg-danger rounded-pill px-3">
                                            <?= number_format((float)$row['score'], 2) ?>
                                        </span>
                                    </td>
                                    <td class="pe-4 text-end small text-white-50">
                                        <?= date('M d, H:i', strtotime($row['created_at'])) ?>
                                    </td>
                                </tr>
                                <?php endforeach; else: ?>
                                <tr><td colspan="4" class="text-center py-5 text-muted small">No final evaluations recorded yet.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card bg-dark border-secondary shadow h-100">
                <div class="card-body p-4">
                    <h5 class="text-white fw-bold mb-4">Management Portal</h5>
                    <div class="d-grid gap-3">
                        <a href="manage_dramas.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm">
                            <i class="bi bi-film me-3 fs-5 text-danger"></i> 
                            <span>Manage Content</span>
                        </a>
                        <a href="manage_users.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm">
                            <i class="bi bi-people me-3 fs-5 text-danger"></i> 
                            <span>Committee Members</span>
                        </a>
                        <a href="member_management.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm">
                            <i class="bi bi-stopwatch me-3 fs-5 text-danger"></i> 
                            <span>Watch-Time Audit</span>
                        </a>
                        <a href="reports.php" class="btn btn-danger py-3 fw-bold mt-2 shadow-sm fs-5">
                            <i class="bi bi-bar-chart-line-fill me-2"></i> 
                            View Analytics
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-800 { font-weight: 800; }
    .card { transition: transform 0.2s; }
    .card:hover { transform: translateY(-2px); }
</style>

<?php include '../includes/footer.php'; ?>