<?php
include '../config/config.php';

// Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

$drama_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// 1. FETCH DRAMA DETAILS
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$drama_id]);
$drama = $stmt->fetch();

if (!$drama) { die("Teledrama not found."); }

// 2. FETCH EVERY MEMBER'S FINAL RATING (Targeting 100.00 scale)
$eval_sql = "SELECT r.*, u.full_name, u.username 
             FROM ratings r 
             JOIN users u ON r.user_id = u.id 
             WHERE r.drama_id = ? AND r.episode_id IS NULL";
$stmt = $pdo->prepare($eval_sql);
$stmt->execute([$drama_id]);
$final_evals = $stmt->fetchAll();

// 3. FETCH DETAILED WATCH TIME PER EPISODE PER MEMBER
$watch_sql = "SELECT e.ep_number, u.full_name, r.watch_time_seconds 
              FROM episodes e
              JOIN ratings r ON e.id = r.episode_id
              JOIN users u ON r.user_id = u.id
              WHERE e.drama_id = ?
              ORDER BY e.ep_number ASC, r.watch_time_seconds DESC";
$stmt = $pdo->prepare($watch_sql);
$stmt->execute([$drama_id]);
$watch_logs = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="text-white fw-bold mb-0">Review Detail: <span class="text-danger"><?= htmlspecialchars($drama['title']) ?></span></h2>
            <p class="text-white-50 small text-uppercase" style="letter-spacing: 1px;">Committee Member Deep-Dive & Watch Audit</p>
        </div>
        <a href="reports.php" class="btn btn-outline-light btn-sm shadow-sm">
            <i class="bi bi-arrow-left me-1"></i> Back to Analytics
        </a>
    </div>

    <div class="card bg-dark border-secondary shadow-lg mb-5">
        <div class="card-header bg-black border-secondary py-3 d-flex justify-content-between align-items-center">
            <h5 class="text-white mb-0"><i class="bi bi-person-check-fill text-danger me-2"></i>Final Committee Evaluations</h5>
            <span class="badge bg-danger rounded-pill px-3"><?= count($final_evals) ?> Submissions</span>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead class="small text-uppercase text-muted">
                    <tr>
                        <th class="ps-4">Evaluator</th>
                        <th class="text-center">Overall Score</th>
                        <th class="text-center">Picture Q.</th>
                        <th class="text-center">Sound Q.</th>
                        <th class="pe-4">Written Observation</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($final_evals): foreach($final_evals as $fe): ?>
                    <tr>
                        <td class="ps-4">
                            <span class="text-white fw-bold d-block"><?= htmlspecialchars($fe['full_name']) ?></span>
                            <small class="text-muted">@<?= htmlspecialchars($fe['username']) ?></small>
                        </td>
                        <td class="text-center">
                            <span class="text-danger fw-bold fs-5">
                                <?= number_format((float)$fe['score'], 2) ?>
                            </span>
                            <small class="text-white-50 d-block" style="font-size: 0.65rem;">/ 100.00</small>
                        </td>
                        <td class="text-center">
                            <span class="text-info fw-bold"><?= number_format((float)$fe['picture_quality'], 2) ?></span>
                            <small class="text-muted d-block" style="font-size: 0.65rem;">/ 100.00</small>
                        </td>
                        <td class="text-center">
                            <span class="text-info fw-bold"><?= number_format((float)$fe['sound_quality'], 2) ?></span>
                            <small class="text-muted d-block" style="font-size: 0.65rem;">/ 100.00</small>
                        </td>
                        <td class="pe-4 small text-white-50">
                            <div class="p-2 bg-black rounded border border-secondary" style="min-width: 200px; font-style: italic;">
                                <?= $fe['review_text'] ? nl2br(htmlspecialchars($fe['review_text'])) : 'No comments provided.' ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; else: ?>
                        <tr><td colspan="5" class="text-center py-5 text-muted small">No final evaluations have been submitted for this production yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    

    <div class="card bg-dark border-secondary shadow-lg">
        <div class="card-header bg-black border-secondary py-3">
            <h5 class="text-white mb-0"><i class="bi bi-clock-history text-danger me-2"></i>Episode Watch-Time Audit Logs</h5>
        </div>
        <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
            <table class="table table-dark table-sm table-hover mb-0 align-middle">
                <thead class="small text-uppercase text-muted sticky-top bg-black">
                    <tr>
                        <th class="ps-4 py-3">Episode</th>
                        <th>Committee Member</th>
                        <th class="pe-4 text-end">Time Recorded</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($watch_logs): foreach($watch_logs as $log): ?>
                    <tr>
                        <td class="ps-4 py-2 text-white">Episode <?= $log['ep_number'] ?></td>
                        <td class="text-white-50 small"><?= htmlspecialchars($log['full_name']) ?></td>
                        <td class="pe-4 text-end">
                            <span class="badge bg-secondary font-monospace" style="letter-spacing: 0.5px;">
                                <?= floor($log['watch_time_seconds'] / 60) ?>m <?= ($log['watch_time_seconds'] % 60) ?>s
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; else: ?>
                        <tr><td colspan="3" class="text-center py-4 text-muted small">No member watch logs recorded for this drama.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>