<?php
include '../config/config.php';
include '../includes/auth.php';

// --- UPDATED TRANSACTIONAL NOTIFICATION FUNCTION ---
function notifyViaMandrill($pdo, $subject, $htmlContent) {
    // Mandrill API Endpoint
    $url = "https://mandrillapp.com/api/1.0/messages/send.json";
    $mandrill_key = 'md-Vjza4GhgRIEoal3e-KKkmw'; // Your verified Mandrill Key

    // Fetch all active committee members
    $stmt = $pdo->query("SELECT email FROM users WHERE role = 'member' AND email IS NOT NULL");
    $members = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($members)) return;

    // Prepare recipients (First one is 'to', others are 'bcc' to keep it clean)
    $recipients = [];
    foreach ($members as $index => $email) {
        $recipients[] = [
            "email" => $email, 
            "type" => ($index === 0) ? "to" : "bcc"
        ];
    }

    $data = [
        "key" => $mandrill_key,
        "message" => [
            "html" => "
                <div style='font-family: Helvetica, Arial, sans-serif; padding: 20px; border-top: 4px solid #e50914; color: #333;'>
                    <div style='text-align: center; margin-bottom: 20px;'>
                        <h2 style='color: #e50914; margin-bottom: 5px;'>Swarnavahini Rating Portal</h2>
                        <hr style='border: 0; border-top: 1px solid #eee;'>
                    </div>
                    $htmlContent
                    <div style='margin-top: 30px; padding-top: 15px; border-top: 1px solid #eee; font-size: 12px; color: #888;'>
                        <p>This is an automated system notification. Please do not reply to this email.</p>
                    </div>
                </div>",
            "subject" => $subject,
            "from_email" => ADMIN_EMAIL,
            "from_name" => "Swarnavahini Ratings",
            "to" => $recipients
        ]
    ];

    $payload = json_encode($data);
    
    // Using Stream Context for better compatibility with your server
    $options = [
        'http' => [
            'header'  => "Content-type: application/json\r\n",
            'method'  => 'POST',
            'content' => $payload,
            'ignore_errors' => true
        ],
        'ssl' => ['verify_peer' => false, 'verify_peer_name' => false]
    ];

    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}

// Handle New Teledrama Submission
if (isset($_POST['add_drama'])) {
    $title = htmlspecialchars($_POST['title']);
    $desc = htmlspecialchars($_POST['description']);
    
    $target_dir = "../uploads/thumbnails/";
    $file_name = time() . "_" . basename($_FILES["thumbnail"]["name"]);
    $target_file = $target_dir . $file_name;

    if (move_uploaded_file($_FILES["thumbnail"]["tmp_name"], $target_file)) {
        $sql = "INSERT INTO dramas (title, description, thumbnail) VALUES (?, ?, ?)";
        $pdo->prepare($sql)->execute([$title, $desc, $file_name]);
        
        // TRIGGER NOTIFICATION
        $emailBody = "
            <h3 style='color: #000;'>New Content Alert: $title</h3>
            <p>A new Teledrama has been added to the portal for evaluation.</p>
            <div style='background: #fdf2f2; padding: 10px; border-left: 3px solid #e50914;'>
                <strong>Deadline:</strong> You have exactly <b>24 hours</b> from now to submit your final evaluation.
            </div>
            <p><a href='".BASE_URL."' style='display: inline-block; padding: 10px 20px; background: #e50914; color: #fff; text-decoration: none; border-radius: 5px; margin-top: 10px;'>Login to Evaluate</a></p>";
        
        notifyViaMandrill($pdo, "New Teledrama Added: $title", $emailBody);

        $success = "Teledrama added and committee notified!";
    }
}

// Handle New Episode Submission
if (isset($_POST['add_episode'])) {
    $drama_id = $_POST['drama_id'];
    $ep_no = $_POST['ep_number'];
    $iframe = $_POST['iframe_code'];

    $sql = "INSERT INTO episodes (drama_id, ep_number, iframe_code) VALUES (?, ?, ?)";
    $pdo->prepare($sql)->execute([$drama_id, $ep_no, $iframe]);

    // Fetch Drama Name for Email
    $dStmt = $pdo->prepare("SELECT title FROM dramas WHERE id = ?");
    $dStmt->execute([$drama_id]);
    $dName = $dStmt->fetchColumn();

    // TRIGGER NOTIFICATION
    $emailBody = "
        <h3 style='color: #000;'>New Episode Notification</h3>
        <p><b>Episode $ep_no</b> of the production <b>$dName</b> is now live on the portal.</p>
        <p>Please watch the episode and update your ratings if necessary.</p>
        <p><a href='".BASE_URL."' style='display: inline-block; padding: 10px 20px; background: #333; color: #fff; text-decoration: none; border-radius: 5px;'>Watch Now</a></p>";
    
    notifyViaMandrill($pdo, "New Episode Alert: $dName (Ep $ep_no)", $emailBody);

    $success = "Episode $ep_no added and members notified!";
}

$dramas = $pdo->query("SELECT * FROM dramas ORDER BY created_at DESC")->fetchAll();
include '../includes/header.php';
?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-white fw-bold">Manage Teledramas</h2>
        <button class="btn btn-danger fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#dramaModal">
            <i class="bi bi-plus-circle me-1"></i> Add Production
        </button>
    </div>

    <?php if(isset($success)): ?>
        <div class="alert alert-success bg-success text-white border-0 shadow-sm mb-4"><?= $success ?></div>
    <?php endif; ?>

    <div class="row">
        <?php foreach ($dramas as $drama): ?>
        <div class="col-md-4 mb-4">
            <div class="card bg-dark border-secondary shadow-sm h-100 drama-card">
                <img src="../uploads/thumbnails/<?= $drama['thumbnail'] ?>" class="card-img-top" style="height: 200px; object-fit: cover; opacity: 0.8;">
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title text-white fw-bold"><?= htmlspecialchars($drama['title']) ?></h5>
                    <p class="text-white-50 small flex-grow-1"><?= substr(htmlspecialchars($drama['description']), 0, 80) ?>...</p>
                    <div class="d-grid gap-2 mt-3">
                        <button class="btn btn-outline-danger btn-sm fw-bold" data-bs-toggle="modal" data-bs-target="#epModal<?= $drama['id'] ?>">
                            <i class="bi bi-plus-lg me-1"></i> Add Episode
                        </button>
                        <a href="view_episodes.php?id=<?= $drama['id'] ?>" class="btn btn-outline-light btn-sm">Manage All</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="epModal<?= $drama['id'] ?>" tabindex="-1">
            <div class="modal-dialog">
                <form class="modal-content bg-dark text-white border-secondary shadow" method="POST">
                    <div class="modal-header border-secondary bg-black">
                        <h5 class="modal-title">Upload Episode: <?= htmlspecialchars($drama['title']) ?></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <input type="hidden" name="drama_id" value="<?= $drama['id'] ?>">
                        <div class="mb-3">
                            <label class="form-label small text-white-50 fw-bold">Episode Number</label>
                            <input type="number" name="ep_number" class="form-control bg-black text-white border-secondary" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label small text-white-50 fw-bold">Iframe / Embed Code</label>
                            <textarea name="iframe_code" class="form-control bg-black text-white border-secondary" rows="4" placeholder="Paste YouTube/Vimeo embed code here..." required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary bg-black">
                        <button type="submit" name="add_episode" class="btn btn-danger w-100 fw-bold">Upload & Notify Committee</button>
                    </div>
                </form>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<div class="modal fade" id="dramaModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content bg-dark text-white border-secondary shadow" method="POST" enctype="multipart/form-data">
            <div class="modal-header border-secondary bg-black">
                <h5 class="modal-title">Register New Production</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="mb-3">
                    <label class="form-label small text-white-50 fw-bold">Production Title</label>
                    <input type="text" name="title" class="form-control bg-black text-white border-secondary" required>
                </div>
                <div class="mb-3">
                    <label class="form-label small text-white-50 fw-bold">Description</label>
                    <textarea name="description" class="form-control bg-black text-white border-secondary" rows="3"></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label small text-white-50 fw-bold">Poster Thumbnail</label>
                    <input type="file" name="thumbnail" class="form-control bg-black text-white border-secondary" accept="image/*" required>
                </div>
            </div>
            <div class="modal-footer border-secondary bg-black">
                <button type="submit" name="add_drama" class="btn btn-danger w-100 fw-bold">Add Production & Notify</button>
            </div>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>