<?php
include '../config/config.php';

// 1. Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

// 2. Get Dynamic Goal: Total Teledramas in system for the audit bar
$total_dramas_count = $pdo->query("SELECT COUNT(*) FROM dramas")->fetchColumn() ?: 1; 

// 3. HANDLE NEW MEMBER CREATION
if (isset($_POST['add_member'])) {
    $username = trim($_POST['username']);
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $password = $_POST['password']; 
    $hashed_pw = password_hash($password, PASSWORD_DEFAULT);
    
    try {
        $sql = "INSERT INTO users (username, full_name, email, password, role) VALUES (?, ?, ?, ?, 'member')";
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute([$username, $full_name, $email, $hashed_pw])) {
            
            // Mailchimp API Logic
            $apiKey = 'YOUR_MAILCHIMP_API_KEY'; 
            $serverPrefix = 'us21'; 
            $url = "https://{$serverPrefix}.api.mailchimp.com/3.0/messages/send";
            $loginUrl = BASE_URL . "index.php";

            $htmlContent = "
                <div style='font-family: sans-serif; padding: 25px; border: 2px solid #e50914; max-width: 600px;'>
                    <h2 style='color: #e50914;'>Account Created: Swarnavahini Ratings</h2>
                    <p>Hello <strong>$full_name</strong>, your evaluator account is ready.</p>
                    <div style='background: #f8f9fa; padding: 15px; border-left: 5px solid #e50914;'>
                        <p><strong>Username:</strong> $username</p>
                        <p><strong>Password:</strong> $password</p>
                    </div>
                </div>";

            $data = ["key" => $apiKey, "message" => [
                "html" => $htmlContent, "subject" => "Your New Swarnavahini Credentials",
                "from_email" => "portal@swarnavahini.lk", "from_name" => "Admin",
                "to" => [["email" => $email, "type" => "to"]]
            ]];

            $options = ['http' => [
                'header' => "Content-type: application/json\r\nAuthorization: Basic " . base64_encode("user:$apiKey") . "\r\n",
                'method' => 'POST', 'content' => json_encode($data), 'ignore_errors' => true
            ], 'ssl' => ['verify_peer' => false, 'verify_peer_name' => false]];

            $context = stream_context_create($options);
            @file_get_contents($url, false, $context);
            
            $success = "Member $full_name created and notified.";
        }
    } catch (PDOException $e) {
        $error = "Error: Username or Email already exists.";
    }
}

// 4. FETCH AUDIT DATA: Count Overall Evaluations (where episode_id is NULL)
$member_stats = $pdo->query("SELECT u.id, u.full_name, u.username, u.last_login,
    COUNT(CASE WHEN r.episode_id IS NULL AND r.score > 0 THEN 1 END) as dramas_evaluated,
    SUM(r.watch_time_seconds) as total_seconds,
    AVG(CASE WHEN r.episode_id IS NULL THEN r.score END) as avg_overall_given
    FROM users u
    LEFT JOIN ratings r ON u.id = r.user_id
    WHERE u.role = 'member'
    GROUP BY u.id
    ORDER BY dramas_evaluated DESC")->fetchAll();

$total_committee_time = $pdo->query("SELECT SUM(watch_time_seconds) FROM ratings")->fetchColumn() ?? 0;

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="row align-items-center mb-4">
        <div class="col-md-6">
            <h2 class="text-white fw-bold mb-0">Committee Audit</h2>
            <p class="text-white-50">Monitoring member productivity across <?= $total_dramas_count ?> Teledramas</p>
        </div>
        <div class="col-md-6 text-md-end">
            <div class="btn-group shadow">
                <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#addMemberModal">
                    <i class="bi bi-person-plus me-1"></i> Add Member
                </button>
                <button onclick="window.print()" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-printer me-1"></i> Print Audit
                </button>
            </div>
        </div>
    </div>

    <?php if(isset($success)): ?>
        <div class="alert alert-success border-0 bg-success text-white mb-4 shadow-sm"><?= $success ?></div>
    <?php endif; ?>

    <div class="row g-3 mb-5">
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 shadow-sm h-100">
                <small class="text-muted text-uppercase fw-bold">Total Evaluation Time</small>
                <h3 class="text-white mb-0">
                    <?= floor($total_committee_time / 3600) ?>h <?= floor(($total_committee_time % 3600) / 60) ?>m
                </h3>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-3 shadow-sm border-start border-danger border-4 h-100">
                <small class="text-muted text-uppercase fw-bold">Active Evaluators</small>
                <h3 class="text-white mb-0"><?= count($member_stats) ?> <span class="fs-6 text-white-50">Members</span></h3>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary shadow-lg">
        <div class="card-header border-secondary bg-transparent py-3">
            <h5 class="text-white mb-0">Member Productivity</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead class="small text-uppercase text-muted">
                    <tr>
                        <th class="ps-4">Member Name</th>
                        <th>Status</th>
                        <th>Dramas Rated</th>
                        <th>Watch Time</th>
                        <th>Avg Score</th>
                        <th class="pe-4 text-end">Last Activity</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($member_stats as $ms): 
                        $is_online = (isset($ms['last_login']) && strtotime($ms['last_login']) > strtotime('-60 seconds'));
                        $progress_percent = ($ms['dramas_evaluated'] / $total_dramas_count) * 100;
                    ?>
                    <tr>
                        <td class="ps-4">
                            <span class="text-white fw-bold d-block"><?= htmlspecialchars($ms['full_name'] ?? 'Unknown') ?></span>
                            <small class="text-muted">@<?= htmlspecialchars($ms['username']) ?></small>
                        </td>
                        <td>
                            <?php if($is_online): ?>
                                <span class="badge bg-success small pulse-status"><i class="bi bi-circle-fill me-1"></i> Live</span>
                            <?php else: ?>
                                <span class="badge bg-secondary small text-white-50">Offline</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <span class="fw-bold me-2"><?= $ms['dramas_evaluated'] ?> / <?= $total_dramas_count ?></span>
                                <div class="progress bg-secondary" style="height: 4px; width: 50px;">
                                    <div class="progress-bar bg-danger" style="width: <?= min($progress_percent, 100) ?>%"></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="text-info small">
                                <?= floor(($ms['total_seconds'] ?? 0) / 60) ?>m <?= ($ms['total_seconds'] ?? 0) % 60 ?>s
                            </span>
                        </td>
                        <td class="text-warning fw-bold"><?= round($ms['avg_overall_given'] ?? 0, 1) ?> <small class="text-muted">/100</small></td>
                        <td class="pe-4 text-end">
                            <small class="text-white-50">
                                <?= $ms['last_login'] ? date('M d, g:i A', strtotime($ms['last_login'])) : 'Never' ?>
                            </small>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="addMemberModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content bg-dark text-white border-secondary" method="POST">
            <div class="modal-header border-secondary">
                <h5 class="modal-title">New Committee Member</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="small text-white-50">Full Name</label>
                    <input type="text" name="full_name" class="form-control bg-dark text-white border-secondary" required>
                </div>
                <div class="mb-3">
                    <label class="small text-white-50">Username</label>
                    <input type="text" name="username" class="form-control bg-dark text-white border-secondary" required>
                </div>
                <div class="mb-3">
                    <label class="small text-white-50">Email Address</label>
                    <input type="email" name="email" class="form-control bg-dark text-white border-secondary" required>
                </div>
                <div class="mb-3">
                    <label class="small text-white-50">Initial Password</label>
                    <input type="text" name="password" class="form-control bg-dark text-white border-secondary" value="MNR_<?= rand(1000, 9999) ?>" required>
                </div>
            </div>
            <div class="modal-footer border-secondary">
                <button type="submit" name="add_member" class="btn btn-danger w-100 shadow">Create & Send Email</button>
            </div>
        </form>
    </div>
</div>

<style>
.pulse-status { animation: pulse-animation 2s infinite; }
@keyframes pulse-animation { 
    0% { transform: scale(1); opacity: 1; } 
    50% { transform: scale(1.05); opacity: 0.7; } 
    100% { transform: scale(1); opacity: 1; } 
}
</style>

<?php include '../includes/footer.php'; ?>