<?php
include '../config/config.php';

// Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { 
    header("Location: " . BASE_URL . "index.php"); 
    exit(); 
}

$report_query = "SELECT d.*, 
                 COUNT(r.id) as total_evaluators, 
                 AVG(r.score) as avg_overall_score,
                 AVG(r.picture_quality) as avg_pic_q,
                 AVG(r.sound_quality) as avg_snd_q
                 FROM dramas d
                 LEFT JOIN ratings r ON d.id = r.drama_id AND r.episode_id IS NULL
                 GROUP BY d.id 
                 ORDER BY d.created_at DESC";

$dramas = $pdo->query($report_query)->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="text-white fw-bold mb-0">Production Analytics</h2>
            <p class="text-white-50 small text-uppercase">Audit Status Monitoring</p>
        </div>
        <button onclick="window.print()" class="btn btn-outline-light btn-sm">
            <i class="bi bi-printer me-1"></i> Print
        </button>
    </div>

    <div class="row g-4">
        <?php foreach ($dramas as $index => $row): 
            $overall = number_format((float)$row['avg_overall_score'], 2, '.', '');
            $pic_avg = number_format((float)$row['avg_pic_q'], 2, '.', '');
            $snd_avg = number_format((float)$row['avg_snd_q'], 2, '.', '');
            
            // --- EXPIRATION LOGIC ---
            $created_timestamp = strtotime($row['created_at']);
            $expiry_timestamp = $created_timestamp + 86400; // 24 hours
            $current_timestamp = time();
            $is_expired = ($current_timestamp > $expiry_timestamp);
            $seconds_left = $expiry_timestamp - $current_timestamp;
        ?>
        <div class="col-md-6 col-lg-4">
            <div class="card bg-dark border-secondary h-100 shadow-lg overflow-hidden <?= $is_expired ? 'opacity-75' : 'border-danger' ?>">
                
                <div class="position-relative">
                    <img src="../uploads/thumbnails/<?= htmlspecialchars($row['thumbnail']) ?>" 
                         class="card-img-top" style="height:200px; object-fit:cover;">
                    
                    <div class="position-absolute top-0 start-0 m-2">
                        <span class="badge <?= $is_expired ? 'bg-secondary' : 'bg-danger' ?> small shadow">
                             <?= $is_expired ? '<i class="bi bi-lock-fill"></i> CLOSED' : '<i class="bi bi-clock-history"></i> LIVE' ?>
                        </span>
                    </div>

                    <div class="position-absolute bottom-0 end-0 m-2">
                        <div class="bg-black border border-secondary p-2 rounded shadow text-center">
                             <small class="text-muted d-block" style="font-size: 10px;">OVERALL</small>
                             <span class="text-white fw-bold"><?= $overall ?>/100</span>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <h5 class="text-white fw-bold mb-1"><?= htmlspecialchars($row['title']) ?></h5>
                    <small class="text-muted d-block mb-3">Added: <?= date('M d, g:i A', $created_timestamp) ?></small>

                    <?php if(!$is_expired): ?>
                        <div class="alert alert-danger py-2 mb-3 border-0 small text-center shadow-sm">
                            <i class="bi bi-hourglass-split me-1"></i>
                            <strong>Time Left:</strong> 
                            <?= floor($seconds_left / 3600) ?>h <?= floor(($seconds_left % 3600) / 60) ?>m
                        </div>
                    <?php else: ?>
                        <div class="alert alert-secondary py-2 mb-3 border-0 small text-center">
                            <i class="bi bi-check-circle-fill me-1 text-success"></i> Data Finalized
                        </div>
                    <?php endif; ?>

                    <div class="row g-2 mb-4">
                        <div class="col-6">
                            <div class="p-2 bg-black rounded text-center border border-secondary">
                                <small class="text-muted d-block small text-uppercase" style="font-size: 0.6rem;">Pic Quality</small>
                                <span class="text-info fw-bold small"><?= $pic_avg ?>/100</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="p-2 bg-black rounded text-center border border-secondary">
                                <small class="text-muted d-block small text-uppercase" style="font-size: 0.6rem;">Snd Quality</small>
                                <span class="text-info fw-bold small"><?= $snd_avg ?>/100</span>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <small class="text-white-50">
                            <i class="bi bi-people-fill me-1"></i> <?= $row['total_evaluators'] ?> Participants
                        </small>
                    </div>

                    <a href="drama_reviews.php?id=<?= $row['id'] ?>" class="btn btn-outline-danger w-100 fw-bold py-2">
                        VIEW DETAILED LOGS
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>