<?php
include '../config/config.php';
include '../includes/auth.php'; 

$user_id = $_SESSION['user_id'];

// --- HANDLE THE EVALUATION SUBMISSION ---
if (isset($_POST['submit_evaluation'])) {
    $drama_id = $_POST['drama_id'];
    
    // Check expiration again on server-side for security
    $stmt = $pdo->prepare("SELECT created_at FROM dramas WHERE id = ?");
    $stmt->execute([$drama_id]);
    $created_at = $stmt->fetchColumn();
    
    if (strtotime($created_at) > strtotime('-24 hours')) {
        $overall_score = (float)$_POST['overall_score']; 
        $pic_q = (float)$_POST['pic_q']; 
        $snd_q = (float)$_POST['snd_q']; 
        $comments = htmlspecialchars($_POST['comments']);

        $sql = "INSERT INTO ratings (user_id, drama_id, episode_id, score, picture_quality, sound_quality, review_text) 
                VALUES (?, ?, NULL, ?, ?, ?, ?) 
                ON DUPLICATE KEY UPDATE 
                score = VALUES(score), 
                picture_quality = VALUES(picture_quality),
                sound_quality = VALUES(sound_quality),
                review_text = VALUES(review_text)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user_id, $drama_id, $overall_score, $pic_q, $snd_q, $comments]);
        $success_msg = "Overall Evaluation Submitted Successfully!";
    } else {
        $error_msg = "Error: The 24-hour review window for this teledrama has expired.";
    }
}

// Fetch all dramas
$stmt = $pdo->query("SELECT * FROM dramas ORDER BY created_at DESC");
$dramas = $stmt->fetchAll();

include '../includes/header.php'; 
?>

<div class="container mt-4 mb-5">
    <div class="p-5 mb-4 bg-dark rounded-3 shadow-lg border border-secondary">
        <div class="container-fluid py-2">
            <h1 class="display-5 fw-bold text-danger">Committee Dashboard</h1>
            <p class="col-md-8 fs-5 text-white-50">Reviews are open for 24 hours only from the time a production is added.</p>
        </div>
    </div>

    <?php if(isset($success_msg)): ?>
        <div class="alert alert-success border-0 bg-success text-white mb-4 shadow"><?= $success_msg ?></div>
    <?php endif; ?>
    
    <?php if(isset($error_msg)): ?>
        <div class="alert alert-danger border-0 bg-danger text-white mb-4 shadow"><?= $error_msg ?></div>
    <?php endif; ?>

    <h3 class="mb-4 fw-bold text-white"><i class="bi bi-clock-history me-2"></i>Active Evaluation Windows</h3>
    
    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 g-4">
        <?php foreach ($dramas as $drama): 
            $check = $pdo->prepare("SELECT score FROM ratings WHERE user_id = ? AND drama_id = ? AND episode_id IS NULL");
            $check->execute([$user_id, $drama['id']]);
            $existing_score = $check->fetchColumn();

            // --- EXPIRATION LOGIC ---
            $created_time = strtotime($drama['created_at']);
            $expiry_time = $created_time + (24 * 3600);
            $current_time = time();
            $is_expired = ($current_time > $expiry_time);
            $time_left = $expiry_time - $current_time;
        ?>
            <div class="col">
                <div class="card h-100 bg-dark border-secondary shadow-sm drama-card <?= $is_expired ? 'opacity-75' : '' ?>">
                    <div class="position-relative">
                        <img src="../uploads/thumbnails/<?= $drama['thumbnail'] ?>" class="card-img-top" style="height: 200px; object-fit: cover;">
                        <?php if(!$is_expired): ?>
                            <span class="position-absolute top-0 end-0 m-2 badge bg-danger shadow">
                                <i class="bi bi-hourglass-split me-1"></i> <?= floor($time_left / 3600) ?>h left
                            </span>
                        <?php else: ?>
                            <span class="position-absolute top-0 end-0 m-2 badge bg-secondary shadow">Expired</span>
                        <?php endif; ?>
                    </div>

                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-bold text-white"><?= htmlspecialchars($drama['title']) ?></h5>
                        
                        <?php if($existing_score !== false): ?>
                            <div class="mb-3">
                                <span class="badge bg-success w-100 py-2">Overall: <?= number_format($existing_score, 2) ?></span>
                            </div>
                        <?php endif; ?>

                        <div class="d-grid gap-2 mt-auto">
                            <a href="episodes.php?drama_id=<?= $drama['id'] ?>" class="btn btn-sm btn-outline-light">Watch Episodes</a>
                            
                            <?php if($is_expired): ?>
                                <button class="btn btn-secondary fw-bold disabled" disabled>
                                    <i class="bi bi-lock-fill me-1"></i> Window Closed
                                </button>
                            <?php else: ?>
                                <button class="btn btn-danger fw-bold" data-bs-toggle="modal" data-bs-target="#evalModal<?= $drama['id'] ?>">
                                    <i class="bi bi-star-half me-1"></i> Rate Teledrama
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(!$is_expired): ?>
            <div class="modal fade" id="evalModal<?= $drama['id'] ?>" tabindex="-1">
                <div class="modal-dialog modal-dialog-centered">
                    <form class="modal-content bg-dark text-white border-secondary" method="POST">
                        <div class="modal-header border-secondary bg-black">
                            <h5 class="modal-title">Final Evaluation: <?= htmlspecialchars($drama['title']) ?></h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body p-4">
                            <input type="hidden" name="drama_id" value="<?= $drama['id'] ?>">
                            <div class="mb-4 text-center p-3 bg-black rounded border border-secondary">
                                <label class="form-label text-danger fw-bold text-uppercase small">Overall Score (0.00 - 100.00)</label>
                                <input type="number" step="0.01" name="overall_score" class="form-control form-control-lg bg-dark text-white border-danger text-center fw-bold" min="0" max="100" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label small">Picture Quality</label>
                                <input type="number" step="0.01" name="pic_q" class="form-control bg-black text-white border-secondary" min="0" max="100" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label small">Sound Quality</label>
                                <input type="number" step="0.01" name="snd_q" class="form-control bg-black text-white border-secondary" min="0" max="100" required>
                            </div>
                            <textarea name="comments" class="form-control bg-black text-white border-secondary mt-3" rows="3" placeholder="Explain your scoring..."></textarea>
                        </div>
                        <div class="modal-footer border-secondary bg-black">
                            <button type="submit" name="submit_evaluation" class="btn btn-danger w-100 py-2 fw-bold shadow">SUBMIT DATA</button>
                        </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>