<?php
include '../config/config.php';
include '../includes/auth.php';

$drama_id = isset($_GET['drama_id']) ? (int)$_GET['drama_id'] : 0;
$user_id = $_SESSION['user_id'];

// 1. Fetch Drama Details
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$drama_id]);
$drama = $stmt->fetch();

if (!$drama) { header("Location: dashboard.php"); exit(); }

// 2. Fetch all episodes for this drama along with the member's specific watch time
$ep_sql = "SELECT e.*, r.watch_time_seconds 
           FROM episodes e 
           LEFT JOIN ratings r ON e.id = r.episode_id AND r.user_id = ? 
           WHERE e.drama_id = ? 
           ORDER BY e.ep_number ASC";
$ep_stmt = $pdo->prepare($ep_sql);
$ep_stmt->execute([$user_id, $drama_id]);
$episodes = $ep_stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php" class="text-danger">Dashboard</a></li>
        <li class="breadcrumb-item active text-white" aria-current="page"><?= htmlspecialchars($drama['title']) ?></li>
      </ol>
    </nav>

    <div class="d-flex align-items-center mb-4 p-3 bg-dark border border-secondary rounded shadow-sm">
        <img src="../uploads/thumbnails/<?= htmlspecialchars($drama['thumbnail']) ?>" class="rounded me-3 shadow" style="width: 120px; height: 120px; object-fit: cover; border: 2px solid #e50914;">
        <div>
            <h2 class="text-white fw-bold mb-0"><?= htmlspecialchars($drama['title']) ?></h2>
            <p class="text-white-50 mb-0 small text-uppercase fw-bold">Episode Directory</p>
            <p class="text-muted mb-0 small">Watch all episodes before submitting your final 100.00 score on the dashboard.</p>
        </div>
    </div>

    

    <div class="row g-3">
        <?php if (count($episodes) > 0): ?>
            <?php foreach ($episodes as $ep): 
                $watched = ($ep['watch_time_seconds'] > 0);
                $minutes = floor($ep['watch_time_seconds'] / 60);
            ?>
                <div class="col-md-3">
                    <div class="card h-100 bg-dark border-secondary hover-shadow position-relative">
                        <?php if($watched): ?>
                            <span class="position-absolute top-0 end-0 m-2 badge bg-success border border-light rounded-pill" style="font-size: 0.6rem;">
                                <i class="bi bi-check-lg"></i> Viewed <?= $minutes ?>m
                            </span>
                        <?php endif; ?>
                        
                        <div class="card-body text-center py-4">
                            <h5 class="text-white fw-bold mb-3">Episode <?= $ep['ep_number'] ?></h5>
                            <a href="watch.php?id=<?= $ep['id'] ?>" class="btn <?= $watched ? 'btn-outline-danger' : 'btn-danger' ?> btn-sm px-4 fw-bold">
                                <i class="bi bi-play-fill"></i> <?= $watched ? 'CONTINUE' : 'WATCH' ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12 text-center py-5 border border-secondary rounded bg-dark">
                <i class="bi bi-camera-video-off fs-1 text-muted mb-3 d-block"></i>
                <p class="text-muted">No episodes have been uploaded for this drama yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.hover-shadow:hover { 
    transform: translateY(-5px); 
    transition: 0.3s; 
    border-color: #e50914 !important; 
    box-shadow: 0 10px 20px rgba(229, 9, 20, 0.2); 
}
</style>

<?php include '../includes/footer.php'; ?>