<?php 
include '../config/config.php'; 
include '../includes/auth.php'; 

$ep_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$user_id = $_SESSION['user_id'];

// 1. HANDLE WATCH TIME ONLY
// We no longer submit scores or reviews here as per the manager's request.
if (isset($_POST['update_watch_time'])) {
    $watch_seconds = isset($_POST['watch_time']) ? (int)$_POST['watch_time'] : 0;
    $drama_id = (int)$_POST['drama_id'];

    // Update watch time for the audit system
    $sql = "INSERT INTO ratings (user_id, drama_id, episode_id, watch_time_seconds, score) 
            VALUES (?, ?, ?, ?, 0) 
            ON DUPLICATE KEY UPDATE 
            watch_time_seconds = watch_time_seconds + VALUES(watch_time_seconds)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_id, $drama_id, $ep_id, $watch_seconds]);
    $msg = "Watch time recorded.";
}

// 2. FETCH EPISODE & DRAMA DETAILS
$stmt = $pdo->prepare("SELECT e.*, d.title, d.id as drama_id FROM episodes e JOIN dramas d ON e.drama_id = d.id WHERE e.id = ?");
$stmt->execute([$ep_id]);
$ep = $stmt->fetch();

if (!$ep) {
    header("Location: dashboard.php");
    exit();
}

include '../includes/header.php'; 
?>

<div class="container mt-4 mb-5">
    <div class="row">
        <div class="col-lg-12">
            <div class="d-flex justify-content-between align-items-end mb-3">
                <div>
                    <h2 class="text-white fw-bold mb-0"><?= htmlspecialchars($ep['title']) ?></h2>
                    <p class="text-danger fw-bold mb-0">Episode <?= $ep['ep_number'] ?></p>
                </div>
                <a href="dashboard.php" class="btn btn-outline-light btn-sm">Back to Dashboard</a>
            </div>
            
            <div class="ratio ratio-16x9 shadow-lg rounded overflow-hidden border border-secondary bg-black mb-4">
                <?= $ep['iframe_code'] ?>
            </div>

            <div class="card bg-dark border-secondary">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div class="text-white-50 small">
                        <i class="bi bi-clock-history me-2"></i> 
                        Evaluating: <span id="timer_display" class="text-white">0s</span> spent on this episode.
                    </div>
                    <form method="POST" id="timeForm">
                        <input type="hidden" name="watch_time" id="watch_time_input" value="0">
                        <input type="hidden" name="drama_id" value="<?= $ep['drama_id'] ?>">
                        <button type="submit" name="update_watch_time" class="btn btn-sm btn-outline-danger">
                            Save Progress
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
let secondsWatched = 0;
let isTabActive = true;

window.onfocus = function() { isTabActive = true; };
window.onblur = function() { isTabActive = false; };

setInterval(() => {
    if (isTabActive) {
        secondsWatched++;
        document.getElementById('watch_time_input').value = secondsWatched;
        document.getElementById('timer_display').innerText = secondsWatched + "s";
    }
}, 1000);

// Auto-save every 60 seconds so users don't lose time if they close the tab
setInterval(() => {
    if(secondsWatched > 10) {
        document.getElementById('timeForm').submit();
    }
}, 60000);
</script>

<?php include '../includes/footer.php'; ?>