<?php
// 1. Include Config
include '../config/config.php';

// 2. Check Authentication & Role
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

// 3. Fetch Statistics (Updated for Episode-based system)
$total_dramas = $pdo->query("SELECT COUNT(*) FROM dramas")->fetchColumn();
$total_members = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'member'")->fetchColumn();

// Count total individual episode ratings submitted by the committee
$total_episode_ratings = $pdo->query("SELECT COUNT(*) FROM ratings WHERE episode_id IS NOT NULL")->fetchColumn();

// 4. Fetch Recent Activity (Updated to show specific episodes being rated)
$recent_activity = $pdo->query("SELECT r.*, u.full_name, d.title, e.ep_number 
                               FROM ratings r 
                               JOIN users u ON r.user_id = u.id 
                               JOIN dramas d ON r.drama_id = d.id 
                               JOIN episodes e ON r.episode_id = e.id
                               ORDER BY r.created_at DESC LIMIT 5")->fetchAll();

include '../includes/header.php'; 
?>

<div class="container mt-4 mb-5">
    <div class="row mb-4 align-items-center">
        <div class="col-md-6">
            <h2 class="fw-bold text-white mb-0">Admin Dashboard</h2>
            <p class="text-white-50 small text-uppercase">Swarnavahini Production Analytics</p>
        </div>
        <div class="col-md-6 text-md-end">
            <span class="badge bg-dark border border-secondary p-2">
                <i class="bi bi-calendar3 me-2 text-danger"></i> <?= date('l, F j, Y') ?>
            </span>
        </div>
    </div>

    <div class="row g-4 mb-5">
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-info">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Total Teledramas</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_dramas ?></h1>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-danger">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Active Evaluators</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_members ?></h1>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-dark border-secondary p-4 shadow-sm h-100 border-start border-4 border-success">
                <small class="text-muted text-uppercase fw-bold mb-2 d-block">Total Episode Audits</small>
                <h1 class="text-white fw-800 mb-0"><?= $total_episode_ratings ?></h1>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-8">
            <div class="card bg-dark border-secondary h-100 shadow">
                <div class="card-header border-secondary bg-black py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-white"><i class="bi bi-clipboard-data me-2 text-danger"></i>Live Audit Stream</h5>
                    <a href="reports.php" class="btn btn-sm btn-outline-danger">View All</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr class="text-muted small text-uppercase border-secondary">
                                    <th class="ps-4">Member</th>
                                    <th>Production</th>
                                    <th>Episode</th>
                                    <th>Score</th>
                                    <th class="pe-4 text-end">Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($recent_activity): foreach($recent_activity as $row): ?>
                                <tr>
                                    <td class="ps-4 py-3">
                                        <span class="fw-bold text-white"><?= htmlspecialchars($row['full_name']) ?></span>
                                    </td>
                                    <td><?= htmlspecialchars($row['title']) ?></td>
                                    <td><span class="badge bg-black border border-secondary text-info">EP <?= $row['ep_number'] ?></span></td>
                                    <td>
                                        <span class="fw-bold text-danger">
                                            <?= number_format((float)$row['score'], 1) ?>
                                        </span>
                                    </td>
                                    <td class="pe-4 text-end small text-white-50">
                                        <?= date('H:i', strtotime($row['created_at'])) ?> <br>
                                        <small><?= date('M d', strtotime($row['created_at'])) ?></small>
                                    </td>
                                </tr>
                                <?php endforeach; else: ?>
                                <tr><td colspan="5" class="text-center py-5 text-muted small">No episode evaluations recorded yet.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card bg-dark border-secondary shadow h-100">
                <div class="card-body p-4">
                    <h5 class="text-white fw-bold mb-4">Quick Management</h5>
                    <div class="d-grid gap-3">
                        <a href="manage_dramas.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm card-btn">
                            <i class="bi bi-plus-circle me-3 fs-5 text-danger"></i> 
                            <span>Add New Production</span>
                        </a>
                        <a href="member_management.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm card-btn">
                            <i class="bi bi-people me-3 fs-5 text-danger"></i> 
                            <span>Committee Audit</span>
                        </a>
                        <a href="settings.php" class="btn btn-outline-light text-start py-3 px-3 shadow-sm card-btn">
                            <i class="bi bi-gear me-3 fs-5 text-danger"></i> 
                            <span>System Settings</span>
                        </a>
                        
                        <a href="reports.php" class="btn btn-danger py-3 fw-bold mt-2 shadow-sm fs-5">
                            <i class="bi bi-bar-chart-line-fill me-2"></i> 
                            Production Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-800 { font-weight: 800; }
    .card-btn { border-color: rgba(255,255,255,0.1); }
    .card-btn:hover { background: #000; border-color: #e50914; }
    .table-hover tbody tr:hover { background-color: rgba(229, 9, 20, 0.05); }
</style>

<?php include '../includes/footer.php'; ?>