<?php
include '../config/config.php';

// Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

$drama_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// 1. FETCH DRAMA & ACTIVE PARAMETERS
$drama_stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?"); 
$drama_stmt->execute([$drama_id]);
$drama = $drama_stmt->fetch();

if (!$drama) { die("Teledrama not found."); }

// Fetch the current parameters to build the table headers
$params = $pdo->query("SELECT * FROM rating_parameters ORDER BY id ASC")->fetchAll();

// 2. FETCH ALL MEMBER RATINGS WITH WATCH TIME
$eval_sql = "SELECT r.*, u.full_name, u.username, e.ep_number 
             FROM ratings r 
             JOIN users u ON r.user_id = u.id 
             JOIN episodes e ON r.episode_id = e.id
             WHERE r.drama_id = ? 
             ORDER BY e.ep_number ASC, r.id DESC";
$stmt = $pdo->prepare($eval_sql); 
$stmt->execute([$drama_id]);
$final_evals = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="text-white fw-bold mb-0">Review Detail: <span class="text-danger"><?= htmlspecialchars($drama['title']) ?></span></h2>
            <p class="text-white-50 small text-uppercase">Audit Logs & Viewing Retention</p>
        </div>
        <a href="reports.php" class="btn btn-outline-light btn-sm">Back to Analytics</a>
    </div>

    <div class="card bg-dark border-secondary shadow-lg">
        <div class="table-responsive">
            <table class="table table-dark align-middle mb-0">
                <thead class="small text-uppercase text-muted bg-black">
                    <tr>
                        <th class="ps-4">Episode</th>
                        <th>Evaluator</th>
                        <th class="text-center">Watch Time</th>
                        <th class="text-center">Total Score</th>
                        <?php foreach($params as $p): ?>
                            <th class="text-center"><?= htmlspecialchars($p['parameter_name']) ?></th>
                        <?php endforeach; ?>
                        <th class="pe-4">Observations</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($final_evals): foreach($final_evals as $fe): 
                        $val_stmt = $pdo->prepare("SELECT parameter_id, score FROM rating_values WHERE rating_id = ?");
                        $val_stmt->execute([$fe['id']]);
                        $scores = $val_stmt->fetchAll(PDO::FETCH_KEY_PAIR);
                    ?>
                    <tr class="border-secondary">
                        <td class="ps-4">
                            <span class="badge bg-danger">EP <?= $fe['ep_number'] ?></span>
                        </td>
                        <td>
                            <span class="text-white fw-bold d-block"><?= htmlspecialchars($fe['full_name']) ?></span>
                            <small class="text-muted">@<?= htmlspecialchars($fe['username']) ?></small>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-dark border border-secondary p-2 font-monospace">
                                <i class="bi bi-clock-history text-danger me-1"></i>
                                <?php 
                                    $mins = floor($fe['watch_time_seconds'] / 60);
                                    $secs = $fe['watch_time_seconds'] % 60;
                                    echo $mins . "m " . $secs . "s";
                                ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="bg-black py-1 rounded border border-secondary">
                                <span class="text-white fw-bold"><?= number_format($fe['score'], 1) ?></span>
                                <small class="text-muted d-block" style="font-size: 0.6rem;">/ 100</small>
                            </div>
                        </td>
                        
                        <?php foreach($params as $p): ?>
                            <td class="text-center text-info small">
                                <?= isset($scores[$p['id']]) ? $scores[$p['id']] : '0' ?> 
                                <span class="text-muted" style="font-size: 0.7rem;">/<?= $p['max_marks'] ?></span>
                            </td>
                        <?php endforeach; ?>

                        <td class="pe-4 small text-white-50 italic">
                            <div class="p-2 bg-black rounded border border-secondary" style="min-width: 150px;">
                                <?= $fe['review_text'] ? htmlspecialchars($fe['review_text']) : 'No comment.' ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; else: ?>
                        <tr>
                            <td colspan="<?= count($params) + 5 ?>" class="text-center py-5 text-muted">
                                No evaluations or watch logs found.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>