<?php
include '../config/config.php';
include '../includes/auth.php';

$id = (int)$_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$id]);
$drama = $stmt->fetch();

if (!$drama) { header("Location: manage_dramas.php"); exit(); }

if (isset($_POST['update_drama'])) {
    $title = htmlspecialchars($_POST['title']);
    $desc = htmlspecialchars($_POST['description']);
    
    $update = $pdo->prepare("UPDATE dramas SET title = ?, description = ? WHERE id = ?");
    if ($update->execute([$title, $desc, $id])) {
        header("Location: manage_dramas.php?success=Production updated");
        exit();
    }
}

include '../includes/header.php';
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card bg-dark border-secondary shadow">
                <div class="card-header bg-black border-secondary py-3">
                    <h5 class="text-white mb-0">Edit Production Details</h5>
                </div>
                <form class="card-body p-4" method="POST">
                    <div class="mb-3">
                        <label class="text-white-50 small fw-bold">Production Title</label>
                        <input type="text" name="title" class="form-control bg-black text-white border-secondary" value="<?= htmlspecialchars($drama['title']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="text-white-50 small fw-bold">Description</label>
                        <textarea name="description" class="form-control bg-black text-white border-secondary" rows="6"><?= htmlspecialchars($drama['description']) ?></textarea>
                    </div>
                    <div class="d-flex gap-2 mt-4">
                        <button type="submit" name="update_drama" class="btn btn-danger flex-grow-1 fw-bold">SAVE CHANGES</button>
                        <a href="manage_dramas.php" class="btn btn-outline-light">CANCEL</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
