<?php
include '../config/config.php';
include '../includes/auth.php'; // Admin only

$user_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch current user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? AND role = 'member'");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) { die("Member not found."); }

if (isset($_POST['update_user'])) {
    $full_name = htmlspecialchars($_POST['full_name']);
    $username  = htmlspecialchars($_POST['username']);
    $email     = htmlspecialchars($_POST['email']);
    $phone     = htmlspecialchars($_POST['phone']);
    $profile_pic = $user['profile_pic']; // Keep old one by default

    // Update Profile Picture if uploaded
    if (!empty($_FILES["profile_pic"]["name"])) {
        $target_dir = "../uploads/profiles/";
        $file_name = "user_" . time() . "_" . basename($_FILES["profile_pic"]["name"]);
        if (move_uploaded_file($_FILES["profile_pic"]["tmp_name"], $target_dir . $file_name)) {
            $profile_pic = $file_name;
        }
    }

    try {
        $sql = "UPDATE users SET username = ?, full_name = ?, email = ?, phone = ?, profile_pic = ? WHERE id = ?";
        $pdo->prepare($sql)->execute([$username, $full_name, $email, $phone, $profile_pic, $user_id]);
        
        header("Location: manage_users.php?updated=1");
        exit();
    } catch (PDOException $e) {
        $error_msg = "Error: Username or Email already exists.";
    }
}

include '../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="text-white fw-bold">Edit Member</h2>
                <a href="manage_users.php" class="btn btn-outline-secondary">Back</a>
            </div>

            <?php if(isset($error_msg)): ?>
                <div class="alert alert-danger"><?= $error_msg ?></div>
            <?php endif; ?>

            <div class="card bg-dark border-secondary shadow p-4">
                <form method="POST" enctype="multipart/form-data">
                    <div class="text-center mb-4">
                        <img src="../uploads/profiles/<?= $user['profile_pic'] ?>" class="rounded-circle border border-danger" width="100" height="100" style="object-fit: cover;">
                        <p class="text-muted small mt-2">Current Profile Picture</p>
                    </div>

                    <div class="mb-3">
                        <label class="form-label text-white-50 small">Full Name</label>
                        <input type="text" name="full_name" class="form-control bg-black text-white border-secondary" value="<?= $user['full_name'] ?>" required>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-white-50 small">Username</label>
                            <input type="text" name="username" class="form-control bg-black text-white border-secondary" value="<?= $user['username'] ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-white-50 small">Phone</label>
                            <input type="text" name="phone" class="form-control bg-black text-white border-secondary" value="<?= $user['phone'] ?>" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label text-white-50 small">Email Address</label>
                        <input type="email" name="email" class="form-control bg-black text-white border-secondary" value="<?= $user['email'] ?>" required>
                    </div>

                    <div class="mb-4">
                        <label class="form-label text-white-50 small">Change Profile Picture</label>
                        <input type="file" name="profile_pic" class="form-control bg-black text-white border-secondary" accept="image/*">
                    </div>

                    <button type="submit" name="update_user" class="btn btn-danger w-100 fw-bold">Update Member Details</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>