<?php
include '../config/config.php';

// Security Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { 
    header("Location: " . BASE_URL . "index.php"); 
    exit(); 
}

$drama_id = (int)$_GET['drama_id'];

// 1. Fetch Drama Info
$stmt = $pdo->prepare("SELECT * FROM dramas WHERE id = ?");
$stmt->execute([$drama_id]);
$drama = $stmt->fetch();

if (!$drama) { die("Teledrama not found."); }

// 2. Fetch Episodes with Total Watch Time accumulated from all members
$ep_sql = "SELECT e.*, 
           SUM(r.watch_time_seconds) as total_watch_seconds, 
           COUNT(DISTINCT r.user_id) as member_count 
           FROM episodes e 
           LEFT JOIN ratings r ON e.id = r.episode_id 
           WHERE e.drama_id = ? 
           GROUP BY e.id 
           ORDER BY e.ep_number ASC";
$ep_stmt = $pdo->prepare($ep_sql);
$ep_stmt->execute([$drama_id]);
$episodes = $ep_stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-end mb-4">
        <div>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-1">
                <li class="breadcrumb-item"><a href="reports.php" class="text-danger">Reports</a></li>
                <li class="breadcrumb-item active text-white"><?= htmlspecialchars($drama['title']) ?></li>
              </ol>
            </nav>
            <h2 class="text-white fw-bold mb-0">Episode Watch-Time Audit</h2>
        </div>
        <a href="drama_reviews.php?id=<?= $drama_id ?>" class="btn btn-danger">
            <i class="bi bi-star-fill me-1"></i> View Final 100pt Ratings
        </a>
    </div>

    

    <div class="row g-4">
        <?php foreach ($episodes as $ep): 
            $total_m = floor($ep['total_watch_seconds'] / 60);
            $total_s = $ep['total_watch_seconds'] % 60;
        ?>
        <div class="col-md-6 col-lg-4">
            <div class="card bg-dark border-secondary h-100 shadow-sm">
                <div class="card-header border-secondary bg-black d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-white">Episode <?= $ep['ep_number'] ?></h5>
                    <span class="badge bg-secondary"><?= $ep['member_count'] ?> Viewers</span>
                </div>
                <div class="card-body">
                    <div class="mb-3 p-2 bg-black rounded border border-secondary text-center">
                        <small class="text-muted d-block text-uppercase small-xs">Total Committee Time</small>
                        <span class="text-danger fw-bold fs-5"><?= $total_m ?>m <?= $total_s ?>s</span>
                    </div>

                    <h6 class="text-white-50 small mb-2 text-uppercase fw-bold" style="font-size: 0.7rem;">Individual Logs:</h6>
                    <div class="list-group list-group-flush border-top border-secondary">
                        <?php
                        // Fetch specific member watch logs for THIS episode
                        $rat_stmt = $pdo->prepare("SELECT r.watch_time_seconds, u.full_name 
                                                  FROM ratings r 
                                                  JOIN users u ON r.user_id = u.id 
                                                  WHERE r.episode_id = ? AND r.watch_time_seconds > 0
                                                  ORDER BY r.watch_time_seconds DESC");
                        $rat_stmt->execute([$ep['id']]);
                        $logs = $rat_stmt->fetchAll();
                        
                        foreach ($logs as $l): ?>
                            <div class="list-group-item bg-transparent text-white border-secondary px-0 py-2 d-flex justify-content-between align-items-center">
                                <span class="small"><?= htmlspecialchars($l['full_name']) ?></span>
                                <span class="badge rounded-pill bg-dark border border-secondary text-info">
                                    <?= floor($l['watch_time_seconds']/60) ?>m <?= $l['watch_time_seconds']%60 ?>s
                                </span>
                            </div>
                        <?php endforeach; ?>
                        
                        <?php if(empty($logs)): ?>
                            <div class="py-3 text-center">
                                <small class="text-muted italic">No watch time recorded yet.</small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<style>
    .small-xs { font-size: 0.65rem; letter-spacing: 1px; }
</style>

<?php include '../includes/footer.php'; ?>