<?php
include '../config/config.php';
include '../includes/auth.php';

// --- 1. HANDLE AUDIT DEADLINE UPDATE ---
if (isset($_POST['update_deadline'])) {
    $hours = (int)$_POST['deadline_hours'];
    
    // Check if key exists first, then update or insert
    $check_stmt = $pdo->prepare("SELECT COUNT(*) FROM site_settings WHERE setting_key = 'audit_deadline_hours'");
    $check_stmt->execute();
    
    if ($check_stmt->fetchColumn() > 0) {
        $stmt = $pdo->prepare("UPDATE site_settings SET setting_value = ? WHERE setting_key = 'audit_deadline_hours'");
    } else {
        $stmt = $pdo->prepare("INSERT INTO site_settings (setting_key, setting_value) VALUES ('audit_deadline_hours', ?)");
    }
    
    $stmt->execute([$hours]);
    $success_deadline = "Audit deadline updated to $hours hours.";
}

// --- 2. HANDLE ADDING PARAMETER ---
if (isset($_POST['add_param'])) {
    $name = htmlspecialchars($_POST['parameter_name']);
    $marks = (int)$_POST['max_marks'];

    $stmt = $pdo->query("SELECT SUM(max_marks) FROM rating_parameters");
    $current_total = $stmt->fetchColumn();

    if (($current_total + $marks) > 100) {
        $error = "Validation Error: Total marks cannot exceed 100. (Current total: $current_total)";
    } else {
        $insert = $pdo->prepare("INSERT INTO rating_parameters (parameter_name, max_marks) VALUES (?, ?)");
        $insert->execute([$name, $marks]);
        $success = "Parameter added successfully.";
    }
}

// --- 3. HANDLE DELETE PARAMETER ---
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM rating_parameters WHERE id = ?")->execute([$id]);
    header("Location: settings.php");
    exit();
}

// --- 4. FETCH CURRENT DATA ---
$params = $pdo->query("SELECT * FROM rating_parameters")->fetchAll();
$total_sum = array_sum(array_column($params, 'max_marks'));

$deadline_hours = $pdo->query("SELECT setting_value FROM site_settings WHERE setting_key = 'audit_deadline_hours'")->fetchColumn() ?: 24;

include '../includes/header.php';
?>

<div class="container mt-4 mb-5">
    <h2 class="text-white fw-bold mb-4">System Settings</h2>

    <div class="row mb-5">
        <div class="col-12">
            <div class="card bg-dark border-secondary shadow-sm">
                <div class="card-body p-4">
                    <h5 class="text-white fw-bold mb-3">
                        <i class="bi bi-clock-history text-danger me-2"></i>Audit Time Configuration
                    </h5>
                    
                    <?php if(isset($success_deadline)): ?>
                        <div class="alert alert-success border-0 small fw-bold mb-3"><?= $success_deadline ?></div>
                    <?php endif; ?>

                    <form method="POST" class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label class="text-white-50 small fw-bold text-uppercase">Evaluation Window (Hours)</label>
                            <div class="input-group mt-1">
                                <input type="number" name="deadline_hours" class="form-control bg-black text-white border-secondary" value="<?= $deadline_hours ?>" min="1" required>
                                <span class="input-group-text bg-secondary border-secondary text-white">Hours</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <button type="submit" name="update_deadline" class="btn btn-danger w-100 fw-bold">UPDATE DEADLINE</button>
                        </div>
                        <div class="col-md-5">
                            <small class="text-muted d-block">This setting defines how many hours a committee member has to evaluate an episode after it is uploaded.</small>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <hr class="border-secondary mb-5">

    <div class="row">
        <div class="col-md-4">
            <h4 class="text-white fw-bold mb-3">Add Criteria</h4>
            <div class="card bg-dark border-secondary p-4 shadow-sm">
                <form method="POST">
                    <div class="mb-3">
                        <label class="text-white-50 small fw-bold text-uppercase">Parameter Name</label>
                        <input type="text" name="parameter_name" class="form-control bg-black text-white border-secondary" placeholder="e.g. Script Quality" required>
                    </div>
                    <div class="mb-3">
                        <label class="text-white-50 small fw-bold text-uppercase">Weight (Max Marks)</label>
                        <input type="number" name="max_marks" class="form-control bg-black text-white border-secondary" placeholder="e.g. 25" required>
                    </div>
                    <button type="submit" name="add_param" class="btn btn-danger w-100 fw-bold shadow-sm" <?= ($total_sum >= 100) ? 'disabled' : '' ?>>
                        <?= ($total_sum >= 100) ? 'Total Limit Reached' : 'ADD PARAMETER' ?>
                    </button>
                </form>
            </div>
            
            <?php if(isset($error)): ?>
                <div class="alert alert-danger border-0 mt-3 small fw-bold"><?= $error ?></div>
            <?php endif; ?>
            <?php if(isset($success)): ?>
                <div class="alert alert-success border-0 mt-3 small fw-bold"><?= $success ?></div>
            <?php endif; ?>
        </div>

        <div class="col-md-8">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="text-white fw-bold mb-0">Evaluation Metrics</h4>
                <span class="badge <?= ($total_sum == 100) ? 'bg-success' : 'bg-warning text-dark' ?> p-2 px-3 shadow-sm">
                    <i class="bi bi-pie-chart-fill me-1"></i> Total Weight: <?= $total_sum ?> / 100
                </span>
            </div>

            <div class="card bg-dark border-secondary overflow-hidden shadow-sm">
                <table class="table table-dark table-hover mb-0 align-middle">
                    <thead class="bg-black">
                        <tr class="small text-white-50 border-secondary">
                            <th class="ps-4 py-3">Metric Name</th>
                            <th class="py-3">Max Score</th>
                            <th class="text-end pe-4 py-3">Management</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($params as $p): ?>
                        <tr class="border-secondary">
                            <td class="ps-4 fw-bold text-white"><?= $p['parameter_name'] ?></td>
                            <td><span class="text-info fw-bold"><?= $p['max_marks'] ?></span> <small class="text-white-50">Points</small></td>
                            <td class="text-end pe-4">
                                <a href="?delete=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger border-0" onclick="return confirm('Deleting this criteria will affect past reports. Continue?')">
                                    <i class="bi bi-trash3"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <?php if(empty($params)): ?>
                            <tr><td colspan="3" class="text-center py-5 text-muted">No parameters defined. Start by adding one.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if($total_sum < 100): ?>
                <div class="mt-3 p-2 px-3 bg-black rounded border border-warning text-warning small shadow-sm">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i> 
                    Incomplete Setup: You need to assign <?= 100 - $total_sum ?> more marks to complete the 100-point scale.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>