/**
 * Teledrama Rating System - Frontend Logic
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // 1. Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, 5000);
    });

    // 2. Rating Button Interaction
    // Visual feedback when a member selects a score
    const ratingButtons = document.querySelectorAll('.btn-check');
    ratingButtons.forEach(btn => {
        btn.addEventListener('change', function() {
            if (this.checked) {
                // Add a small pulse effect to the label
                const label = document.querySelector(`label[for="${this.id}"]`);
                label.classList.add('animate-pulse');
                setTimeout(() => label.classList.remove('animate-pulse'), 500);
            }
        });
    });

    // 3. Iframe Protection
    // Prevents the iframe from breaking the layout on small screens
    const iframes = document.querySelectorAll('iframe');
    iframes.forEach(iframe => {
        iframe.setAttribute('loading', 'lazy');
        iframe.style.width = '100%';
    });

    // 4. Form Validation for Admin
    // Ensures admin doesn't submit empty episodes
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });

});

/**
 * Helper: Copy Iframe Code (Useful for Admin Dashboard)
 */
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        alert('Iframe code copied to clipboard!');
    });
}