<?php
session_start();

// Database Settings
$host = 'localhost';
$db   = 'ratings_db'; 
$user = 'root';        
$pass = '';            

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Path Management
// Updated to handle both Web and CLI (Cron) environments
$base_url = (isset($_SERVER['HTTP_HOST'])) ? "http://" . $_SERVER['HTTP_HOST'] . "/teledrama_rating_v2/" : "http://yourdomain.com/teledrama_rating_v2/";
if (!defined('BASE_URL')) define('BASE_URL', $base_url);

// Notification Settings
define('MAILCHIMP_API_KEY', 'YOUR_MAILCHIMP_API_KEY');
define('MAILCHIMP_SERVER', 'us21'); // e.g. us21
define('ADMIN_EMAIL', 'teldramaratings@test.athavaneng.com');

function checkLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: " . BASE_URL . "index.php");
        exit();
    }
}
?>