<?php
include 'config/config.php';

$username = 'admin';
$password = 'admin123';
$hash = password_hash($password, PASSWORD_DEFAULT);

try {
    // 1. Repair Table Column
    $pdo->exec("ALTER TABLE users MODIFY COLUMN password VARCHAR(255) NOT NULL");

    // 2. Update Admin with a FRESH hash
    $stmt = $pdo->prepare("UPDATE users SET password = ?, role = 'admin' WHERE username = ?");
    $stmt->execute([$hash, $username]);

    echo "<h3>Step 1: Database Updated</h3>";
    
    // 3. Immediate Test
    $test_stmt = $pdo->prepare("SELECT password FROM users WHERE username = ?");
    $test_stmt->execute([$username]);
    $stored_hash = $test_stmt->fetchColumn();

    echo "Stored Hash: <code>$stored_hash</code><br>";
    
    if (password_verify($password, $stored_hash)) {
        echo "<h3 style='color:green'>Step 2: Verification Passed!</h3>";
        echo "The PHP code can verify 'admin123'. If index.php still fails, check for extra spaces in your HTML form.";
    } else {
        echo "<h3 style='color:red'>Step 2: Verification Failed!</h3>";
        echo "Your PHP version or server configuration is not handling password_verify correctly.";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}