<?php
// We don't start session here because it's already started in config.php

/**
 * Restriction 1: Must be logged in to see any page
 */
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "index.php");
    exit();
}

/**
 * Restriction 2: Prevent Members from accessing Admin folders
 * This checks if the current URL contains '/admin/'
 */
$current_path = $_SERVER['REQUEST_URI'];

if (strpos($current_path, '/admin/') !== false) {
    if ($_SESSION['role'] !== 'admin') {
        // Redirect members to their own dashboard if they try to sneak into admin area
        header("Location: " . BASE_URL . "member/dashboard.php");
        exit();
    }
}

/**
 * Restriction 3: Prevent Admin from rating teledramas
 * (Optional: If you want admins only to manage, not to rate)
 */
if (strpos($current_path, '/member/') !== false) {
    if ($_SESSION['role'] === 'admin') {
        // Redirect admin to their dashboard if they accidentally enter member area
        header("Location: " . BASE_URL . "admin/dashboard.php");
        exit();
    }
}
?>