<?php
include '../config/config.php';
include '../includes/auth.php'; 

$user_id = $_SESSION['user_id'];

// 1. FETCH DYNAMIC DEADLINE
$deadline_h = $pdo->query("SELECT setting_value FROM site_settings WHERE setting_key = 'audit_deadline_hours'")->fetchColumn() ?: 24;
$deadline_seconds = $deadline_h * 3600;

// 2. FETCH ALL DRAMAS (For Active Tab)
$stmt = $pdo->query("SELECT * FROM dramas ORDER BY created_at DESC");
$dramas = $stmt->fetchAll();

// 3. FETCH RATING HISTORY (For History Tab - Non Editable)
$history_sql = "SELECT r.score, r.created_at as rated_on, e.ep_number, d.title 
                FROM ratings r
                JOIN episodes e ON r.episode_id = e.id
                JOIN dramas d ON r.drama_id = d.id
                WHERE r.user_id = ?
                ORDER BY r.created_at DESC";
$h_stmt = $pdo->prepare($history_sql);
$h_stmt->execute([$user_id]);
$history = $h_stmt->fetchAll();

include '../includes/header.php'; 
?>

<div class="container mt-4 mb-5">
    <div class="p-5 mb-4 bg-dark rounded-3 shadow-lg border border-secondary">
        <div class="container-fluid py-2">
            <h1 class="display-5 fw-bold text-danger">Committee Dashboard</h1>
            <p class="col-md-8 fs-5 text-white-50">Welcome back. You can manage live evaluations or view your past submission history below.</p>
        </div>
    </div>

    <ul class="nav nav-pills mb-4 border-bottom border-secondary pb-3" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active fw-bold text-uppercase me-2" id="pills-active-tab" data-bs-toggle="pill" data-bs-target="#pills-active" type="button" role="tab">
                <i class="bi bi-play-circle me-2"></i>Active Evaluations
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link fw-bold text-uppercase" id="pills-history-tab" data-bs-toggle="pill" data-bs-target="#pills-history" type="button" role="tab">
                <i class="bi bi-clock-history me-2"></i>Rating History
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-active" role="tabpanel">
            <h3 class="mb-4 fw-bold text-white small text-uppercase opacity-50">Current Evaluation Windows</h3>
            <div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 g-4">
                <?php foreach ($dramas as $drama): 
                    // Use Dynamic Deadline for Status Badge
                    $ep_stmt = $pdo->prepare("SELECT created_at FROM episodes WHERE drama_id = ? ORDER BY created_at DESC LIMIT 1");
                    $ep_stmt->execute([$drama['id']]);
                    $latest_ep = $ep_stmt->fetch();

                    $is_active = false;
                    if ($latest_ep) {
                        $expiry_time = strtotime($latest_ep['created_at']) + $deadline_seconds;
                        $is_active = (time() < $expiry_time);
                    }
                ?>
                    <div class="col">
                        <div class="card h-100 bg-dark border-secondary shadow-sm drama-card <?= !$is_active ? 'opacity-75' : 'border-danger border-opacity-50' ?>">
                            <div class="card-body d-flex flex-column p-4">
                                <div class="mb-2">
                                    <?php if($is_active): ?>
                                        <span class="badge bg-danger mb-2 small">LIVE AUDIT</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary mb-2 small text-white-50">CLOSED</span>
                                    <?php endif; ?>
                                </div>
                                
                                <h5 class="card-title fw-bold text-white mb-2"><?= htmlspecialchars($drama['title']) ?></h5>
                                <p class="card-text text-white-50 small flex-grow-1">
                                    <?= substr(htmlspecialchars($drama['description']), 0, 80) ?>...
                                </p>

                                <div class="d-grid gap-2 mt-4">
                                    <a href="episodes.php?drama_id=<?= $drama['id'] ?>" class="btn <?= $is_active ? 'btn-danger' : 'btn-outline-light' ?> fw-bold btn-sm">
                                        View Episodes
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-history" role="tabpanel">
            <div class="card bg-dark border-secondary shadow-lg overflow-hidden">
                <div class="card-header bg-black py-3 border-secondary">
                    <h5 class="text-white mb-0 small text-uppercase fw-bold">Your Submission Log</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-dark table-hover mb-0 align-middle">
                        <thead class="bg-black text-white-50 small text-uppercase">
                            <tr class="border-secondary">
                                <th class="ps-4 py-3">Production Name</th>
                                <th>Episode</th>
                                <th>Score Given</th>
                                <th>Date Submitted</th>
                                <th class="text-end pe-4">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($history as $h): ?>
                            <tr class="border-secondary">
                                <td class="ps-4 fw-bold text-white">
                                    <?= htmlspecialchars($h['title']) ?>
                                </td>
                                <td>
                                    <span class="badge bg-dark border border-secondary text-info">EP <?= $h['ep_number'] ?></span>
                                </td>
                                <td>
                                    <span class="h5 fw-bold text-danger mb-0"><?= number_format($h['score'], 0) ?></span>
                                    <small class="text-muted">/ 100</small>
                                </td>
                                <td>
                                    <small class="text-white-50"><?= date('M d, Y | g:i A', strtotime($h['rated_on'])) ?></small>
                                </td>
                                <td class="text-end pe-4">
                                    <span class="text-success small fw-bold text-uppercase">
                                        <i class="bi bi-lock-fill me-1"></i> Finalized
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            
                            <?php if (empty($history)): ?>
                                <tr>
                                    <td colspan="5" class="text-center py-5">
                                        <i class="bi bi-info-circle text-muted d-block mb-2 fs-3"></i>
                                        <p class="text-muted mb-0">No rating history found in your account.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
/* Dashboard Tab Styling */
.nav-pills .nav-link { color: #888; border: 1px solid transparent; transition: all 0.3s ease; }
.nav-pills .nav-link.active { background-color: #e50914 !important; color: white !important; box-shadow: 0 4px 15px rgba(229, 9, 20, 0.3); }
.nav-pills .nav-link:hover:not(.active) { border-color: #e50914; color: #e50914; }

.drama-card { transition: transform 0.2s ease; }
.drama-card:hover { transform: translateY(-5px); }
</style>

<?php include '../includes/footer.php'; ?>